/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.DeleteElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;

public class DeleteModelElement
extends DeleteElement {
    public DeleteModelElement(IModelManager manager, int variableI) {
        super(manager, variableI);
    }

    @Override
    protected boolean delete(MatchingFrame frame) throws GTOperationException {
        IModelElement elementToDelete = null;
        try {
            elementToDelete = (IModelElement)frame.getValue(this.variableIndex);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (elementToDelete == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            this.manager.deleteElement(elementToDelete, EDeleteSemantics.DELETE_SEMANTICS_BRANCH_FORCE);
            frame.setValue(this.variableIndex, ValueKind.UNDEF_LITERAL);
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] ModelElement '{1}' deletion failed due to: {2} ", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        return true;
    }

    @Override
    public String toString() {
        return "Del: " + this.variableIndex;
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement();
    }
}

