/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.MoveElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class MoveBoundunderConstant
extends MoveElement {
    IEntity container;
    SearchGraphEdge relatedSearchGraphEdge;

    public MoveBoundunderConstant(IModelManager manager, IEntity cont, int variable, SearchGraphEdge edge) {
        super(manager, variable);
        this.container = cont;
        this.relatedSearchGraphEdge = edge;
    }

    @Override
    public boolean update(MatchingFrame frame) throws GTOperationException {
        IEntity variableElement = null;
        try {
            variableElement = (IEntity)frame.getValue(this.variableIndex);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not an Entity", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.container == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (variableElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            this.manager.moveEntityTo(variableElement, this.container);
            return true;
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{this.container.getFullyQualifiedName(), frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] The move element under a new container operation failed, between the Element '{1}' and the Container '{2}' due to {3}", context, this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement());
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.variableIndex + " -- move under -> " + this.container.getName();
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

