/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTRuleBuildingException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTElementMapping;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTElementMappingType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTOperationContext;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTOperationGenerator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.DeleteModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.ElementManipulationOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.IUpdatePlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.validation.GTRuleValidator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.VPMModelElementType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.VariableID;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.ChuiEdmonds;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.ISearchGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.VPMPatternOperationGenerator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.BodyNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.DanglingVPMElementDTO;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.FlattenedPattern;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNodeIncremental;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternReferenceNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ISearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.AbstractNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.ConstantSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.EdgeTypeinAlgorithm;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.PatternCallSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.VariableSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.AbstractTraceabilityElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.ConstantNodeTraceabilityElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.EdgeTraceabilityElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.NodeTraceabilityElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.PatternCallNodeTraceabilityElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.VariableNodeTraceabilityElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ContainmentMode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relationship;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.SupertypeOf;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.TypeOf;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.VPMElement;

public class VPMBasedSearchGraph
implements ISearchGraph {
    public static final int BELOW_WEIGHT = 40;
    public static final int IN_WEIGHT = 10;
    public static final int INSTANCEOF_WEIGHT = 20;
    public static final int SUPERTYPE_WEIGHT = 10;
    public static final int RELATION_WEIGHT = 15;
    public static final int PATTERNCALLINV_WEIGHT = 4;
    public static final int PATTERNCALL_WEIGHT = 20;
    public static final int PATTERNCALL_INCREMENTAL_WEIGHT = 9;
    public static final int PATTERNCALL_STORAGE_INCREMENTAL_WEIGHT = 7;
    private static final int VPM_ENTITY = -1;
    private static final int VPM_RELATION = -2;
    private static final int PATTERN_CALL_STORAGE_NODE = -3;
    private static final int CONSTANTNODE_STARTING_ID = -4;
    private int constantNodesNumber = -4;
    private final ChuiEdmonds alg;
    private TreeMap<Integer, SearchGraphNode> searchNodes;
    private SearchGraphNode[] searchNodeOrder = null;
    private final TreeMap<String, Integer> constantNodes;
    private Map<SearchGraphNode, Boolean> hasOneInConstraint;
    private final ArrayList<DanglingVPMElementDTO> danglingElements;
    private final Map<AbstractNode, AbstractTraceabilityElement> traceabilityMapping;
    private final int constantNodeNumber = -4;

    public VPMBasedSearchGraph(IModelManager manager) {
        this.alg = new ChuiEdmonds(manager);
        this.searchNodes = new TreeMap();
        this.constantNodes = new TreeMap();
        this.danglingElements = new ArrayList();
        this.traceabilityMapping = new HashMap<AbstractNode, AbstractTraceabilityElement>();
    }

    public void setSearchNodes(TreeMap<Integer, SearchGraphNode> searchGraph) {
        this.searchNodes = searchGraph;
    }

    public TreeMap<String, Integer> getConstantNodes() {
        return this.constantNodes;
    }

    @Override
    public TreeMap<Integer, SearchGraphNode> getSearchNodes() {
        return this.searchNodes;
    }

    public int getConstantNodeNumber() {
        return -4;
    }

    @Override
    public SearchGraphNode getSearchNode(Integer key) {
        return this.searchNodes.get(key);
    }

    public boolean containsKey(Object key) {
        return this.searchNodes.containsKey(key);
    }

    @Override
    public void initSearchGraph() {
        this.alg.init();
        for (SearchGraphNode node : this.searchNodes.values()) {
            node.setChecked(false);
            node.setVirtualSearchGraphNode(null);
            for (SearchGraphEdge edge : node.getSources()) {
                edge.setEdgeTypeinAlgorithm(EdgeTypeinAlgorithm.FREE);
                edge.setChecked(false);
                edge.setWeight(edge.getOldWeight());
                node.setOutgoingTreeEdgeNumber(0);
            }
            node.setTreeEdge(null);
        }
    }

    @Override
    public void add(BodyNode bodyNode, FlattenedPattern result) throws PatternMatcherCompileTimeException {
        Object obj;
        GTPatternBody body = bodyNode.getBody();
        TreeIterator elements_iter = body.getPatternGraph().eAllContents();
        while (elements_iter.hasNext()) {
            obj = elements_iter.next();
            if (!(obj instanceof Relation) && !(obj instanceof Entity)) continue;
            this.evaluateModelElement((ModelElement)obj, result, bodyNode);
        }
        elements_iter = body.getPatternGraph().eAllContents();
        while (elements_iter.hasNext()) {
            obj = elements_iter.next();
            if (obj instanceof Relation) {
                this.connectElements((Relation)obj, result, bodyNode);
            }
            if (!(obj instanceof Relationship)) continue;
            this.evaluateRelationship((Relationship)obj, result, bodyNode);
        }
        Iterator iter_dangling = body.getDanglingRelations().iterator();
        while (iter_dangling.hasNext()) {
            this.danglingElements.add(new DanglingVPMElementDTO((VPMElement)iter_dangling.next(), bodyNode));
        }
        Iterator iter_dangling_relship = body.getDanglingRelationships().iterator();
        while (iter_dangling_relship.hasNext()) {
            this.danglingElements.add(new DanglingVPMElementDTO((VPMElement)iter_dangling.next(), bodyNode));
        }
        ListIterator containmentConstraints = body.getContainmentConstraints().listIterator();
        while (containmentConstraints.hasNext()) {
            this.evaluateContainmentConstraints((ContainmentConstraint)containmentConstraints.next(), result, bodyNode);
        }
    }

    private void evaluateContainmentConstraints(ContainmentConstraint conCons, FlattenedPattern result, BodyNode bodyNode) {
        SearchGraphEdge edge = new SearchGraphEdge();
        SearchGraphEdge invedge = new SearchGraphEdge();
        SearchGraphNode target = this.getSearchNode(result.getIndex(bodyNode.getVariableID(conCons.getVariable())));
        EdgeTraceabilityElement edgeTraceability = new EdgeTraceabilityElement(edge, (AnnotatedElement)conCons);
        this.traceabilityMapping.put(edge, edgeTraceability);
        EdgeTraceabilityElement inverseEdgeTraceability = new EdgeTraceabilityElement(invedge, (AnnotatedElement)conCons);
        this.traceabilityMapping.put(invedge, inverseEdgeTraceability);
        if (conCons.getMode() == ContainmentMode.BELOW_LITERAL) {
            edge.setVPMEdgeType(EdgeType.BELOW);
            edge.setOldWeight(40);
            edge.setWeight(40);
            invedge.setVPMEdgeType(EdgeType.BELOW);
            invedge.setOldWeight(80);
            invedge.setWeight(80);
        } else {
            edge.setVPMEdgeType(EdgeType.IN);
            edge.setOldWeight(10);
            edge.setWeight(10);
            invedge.setVPMEdgeType(EdgeType.IN);
            invedge.setOldWeight(20);
            invedge.setWeight(20);
        }
        if (conCons.getParent() instanceof VariableReference && result.containsIndex(bodyNode.getVariableID(((VariableReference)conCons.getParent()).getVariable()))) {
            VariableSearchGraphNode source;
            VariableID parentID = bodyNode.getVariableID(((VariableReference)conCons.getParent()).getVariable());
            if (this.searchNodes.containsKey(result.getIndex(parentID))) {
                source = (VariableSearchGraphNode)this.getSearchNode(result.getIndex(parentID));
            } else {
                source = new VariableSearchGraphNode();
                source.setVpmModelElementType(VPMModelElementType.ENTITY);
                source.setInput(true);
                source.setName(parentID.toString());
                source.setId(result.getIndex(parentID));
                this.searchNodes.put(source.getId(), source);
                VariableNodeTraceabilityElement traceability = new VariableNodeTraceabilityElement(source, (AnnotatedElement)conCons.getParent());
                this.traceabilityMapping.put(source, traceability);
            }
            edge.setName(String.valueOf(conCons.getVariable().getName()) + "_Containment");
            edge.setTargetNode(target);
            edge.setSourceNode(source);
            edge.setSource(true);
            target.addSource(edge);
            edge.setInverseEdge(invedge);
            invedge.setName(String.valueOf(conCons.getVariable().getName()) + "_ContainmentInverse");
            invedge.setTargetNode(source);
            invedge.setSourceNode(target);
            invedge.setSource(false);
            source.addSource(invedge);
        } else if (conCons.getParent() instanceof Constant) {
            ConstantSearchGraphNode source;
            Constant constant = (Constant)conCons.getParent();
            if (this.constantNodes.containsKey(constant.getValue())) {
                source = (ConstantSearchGraphNode)this.getSearchNode(this.constantNodes.get(constant.getValue()));
            } else {
                source = new ConstantSearchGraphNode();
                source.setElement(constant.getValue());
                source.setName(constant.getValue());
                this.searchNodes.put(this.constantNodesNumber, source);
                this.constantNodes.put(source.getName(), this.constantNodesNumber);
                --this.constantNodesNumber;
                ConstantNodeTraceabilityElement traceability = new ConstantNodeTraceabilityElement(source, (AnnotatedElement)conCons.getParent());
                this.traceabilityMapping.put(source, traceability);
            }
            edge.setName(String.valueOf(conCons.getVariable().getName()) + "_Containment");
            edge.setTargetNode(target);
            edge.setSourceNode(source);
            edge.setSource(true);
            target.addSource(edge);
        } else {
            int index = result.addVariable(null);
            CheckOperation operation = bodyNode.getTermEvaluationOperation(result.getTermHandler(), conCons, index);
            result.addPreSearchPlanOperation(operation);
            VariableSearchGraphNode source = new VariableSearchGraphNode();
            source.setInput(true);
            source.setVpmModelElementType(VPMModelElementType.ENTITY);
            source.setName("PROCCESEDTERM_" + index);
            source.setId(index);
            this.searchNodes.put(index, source);
            VariableNodeTraceabilityElement traceability = new VariableNodeTraceabilityElement(source, (AnnotatedElement)conCons.getParent());
            this.traceabilityMapping.put(source, traceability);
            edge.setName(String.valueOf(conCons.getVariable().getName()) + "_Containment");
            edge.setTargetNode(target);
            edge.setSourceNode(source);
            edge.setSource(true);
            target.addSource(edge);
        }
    }

    private void connectElements(Relation rel, FlattenedPattern result, BodyNode bodyNode) throws PatternMatcherCompileTimeException {
        SearchGraphNode relationnode;
        SearchGraphNode target;
        SearchGraphNode source;
        String fromStr = rel.getFromStr();
        String toStr = rel.getToStr();
        Integer toIndex = result.getIndex(bodyNode.getVariableID(toStr));
        Integer fromIndex = result.getIndex(bodyNode.getVariableID(fromStr));
        Integer relIndex = result.getIndex(bodyNode.getVariableID((ModelElement)rel));
        if (fromIndex != null && this.searchNodes.containsKey(fromIndex)) {
            source = this.getSearchNode(fromIndex);
        } else if (this.constantNodes.containsKey(fromStr)) {
            source = this.getSearchNode(this.constantNodes.get(fromStr));
        } else {
            String[] context = new String[]{rel.getName(), rel.getFromStr()};
            throw new PatternMatcherCompileTimeException("The source '{2}' of the '{1}' relation cannot be resolved", context, (AnnotatedElement)rel);
        }
        if (toIndex != null && this.searchNodes.containsKey(toIndex)) {
            target = this.getSearchNode(toIndex);
        } else if (this.constantNodes.containsKey(toStr)) {
            target = this.getSearchNode(this.constantNodes.get(toStr));
        } else {
            this.danglingElements.add(new DanglingVPMElementDTO((VPMElement)rel, bodyNode));
            return;
        }
        if (relIndex != null && this.searchNodes.containsKey(relIndex)) {
            relationnode = this.getSearchNode(relIndex);
        } else if (this.constantNodes.containsKey(rel.getName())) {
            relationnode = this.getSearchNode(this.constantNodes.get(rel.getName()));
        } else {
            String[] context = new String[]{rel.getName()};
            throw new PatternMatcherCompileTimeException("The relation '{1}' cannot be resolved", context, (AnnotatedElement)rel);
        }
        SearchGraphEdge edgeTarget = new SearchGraphEdge();
        SearchGraphEdge edgeTargetinverse = new SearchGraphEdge();
        SearchGraphEdge edgeSource = new SearchGraphEdge();
        SearchGraphEdge edgeSourceinverse = new SearchGraphEdge();
        edgeSource.setSourceNode(relationnode);
        edgeSource.setTargetNode(source);
        edgeSource.setSource(true);
        edgeSource.setWeight(15);
        edgeSource.setOldWeight(15);
        edgeSource.setVPMEdgeType(EdgeType.SOURCE);
        edgeSource.setName(String.valueOf(relationnode.getName()) + "->" + source.getName());
        source.addSource(edgeSource);
        edgeSourceinverse.setSourceNode(source);
        edgeSourceinverse.setTargetNode(relationnode);
        edgeSourceinverse.setSource(false);
        edgeSourceinverse.setWeight(15);
        edgeSourceinverse.setOldWeight(15);
        edgeSourceinverse.setVPMEdgeType(EdgeType.SOURCE);
        edgeSourceinverse.setName(String.valueOf(source.getName()) + "->" + relationnode.getName());
        relationnode.addSource(edgeSourceinverse);
        edgeSource.setInverseEdge(edgeSourceinverse);
        edgeTarget.setTargetNode(target);
        edgeTarget.setSourceNode(relationnode);
        edgeTarget.setSource(true);
        edgeTarget.setWeight(15);
        edgeTarget.setOldWeight(15);
        edgeTarget.setVPMEdgeType(EdgeType.TARGET);
        edgeTarget.setName(String.valueOf(relationnode.getName()) + "->" + target.getName());
        target.addSource(edgeTarget);
        edgeTargetinverse.setTargetNode(relationnode);
        edgeTargetinverse.setSourceNode(target);
        edgeTargetinverse.setSource(false);
        edgeTargetinverse.setWeight(15);
        edgeTargetinverse.setOldWeight(15);
        edgeTargetinverse.setVPMEdgeType(EdgeType.TARGET);
        edgeTargetinverse.setName(String.valueOf(target.getName()) + "->" + relationnode.getName());
        relationnode.addSource(edgeTargetinverse);
        edgeTarget.setInverseEdge(edgeTargetinverse);
        EdgeTraceabilityElement sourceEdgeTraceability = new EdgeTraceabilityElement(edgeSource, (AnnotatedElement)rel);
        this.traceabilityMapping.put(edgeSource, sourceEdgeTraceability);
        EdgeTraceabilityElement sourceInverseEdgeTraceability = new EdgeTraceabilityElement(edgeSourceinverse, (AnnotatedElement)rel);
        this.traceabilityMapping.put(edgeSourceinverse, sourceInverseEdgeTraceability);
        EdgeTraceabilityElement targetEdgeTraceability = new EdgeTraceabilityElement(edgeTarget, (AnnotatedElement)rel);
        this.traceabilityMapping.put(edgeTarget, targetEdgeTraceability);
        EdgeTraceabilityElement targetInverseEdgeTraceability = new EdgeTraceabilityElement(edgeTargetinverse, (AnnotatedElement)rel);
        this.traceabilityMapping.put(edgeTargetinverse, targetInverseEdgeTraceability);
    }

    private boolean isDangling(VPMElement element, BodyNode bodyNode, List<DanglingVPMElementDTO> alreadyProcessedDanglings) {
        GTPatternBody body = bodyNode.getBody();
        if (alreadyProcessedDanglings.contains(element)) {
            return Boolean.FALSE;
        }
        Iterator iter = body.getDanglingRelations().iterator();
        while (iter.hasNext()) {
            TreeIterator elements_iter = ((EObject)iter.next()).eAllContents();
            while (elements_iter.hasNext()) {
                if (!((EObject)elements_iter.next()).equals(element)) continue;
                return Boolean.TRUE;
            }
        }
        Iterator iter2 = body.getDanglingRelationships().iterator();
        while (iter.hasNext()) {
            TreeIterator elements_iter = ((EObject)iter2.next()).eAllContents();
            while (elements_iter.hasNext()) {
                if (!((EObject)elements_iter.next()).equals(element)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void evaluateDanglingElements(List<DanglingVPMElementDTO> danglings, FlattenedPattern result, List<DanglingVPMElementDTO> alreadyProcessedDanglings) throws PatternMatcherCompileTimeException {
        ArrayList<DanglingVPMElementDTO> additionalDanglingElements = new ArrayList<DanglingVPMElementDTO>();
        for (DanglingVPMElementDTO dto : danglings) {
            VPMElement element = dto.getElement();
            BodyNode bodyNode = dto.getBodyNode();
            if (element instanceof Relation) {
                this.evaluateModelElement((ModelElement)element, result, bodyNode);
                for (ModelElement elem : ((Relation)element).getType()) {
                    if (!this.isDangling((VPMElement)elem, bodyNode, alreadyProcessedDanglings)) continue;
                    additionalDanglingElements.add(new DanglingVPMElementDTO((VPMElement)elem, bodyNode));
                }
                for (ModelElement elem : ((Relation)element).getSuperRelationships()) {
                    if (!this.isDangling((VPMElement)elem, bodyNode, alreadyProcessedDanglings)) continue;
                    additionalDanglingElements.add(new DanglingVPMElementDTO((VPMElement)elem, bodyNode));
                }
                for (ModelElement elem : ((Relation)element).getRelationsFrom()) {
                    if (!this.isDangling((VPMElement)elem, bodyNode, alreadyProcessedDanglings)) continue;
                    additionalDanglingElements.add(new DanglingVPMElementDTO((VPMElement)elem, bodyNode));
                }
                for (ModelElement elem : ((Relation)element).getRelationsTo()) {
                    if (!this.isDangling((VPMElement)elem, bodyNode, alreadyProcessedDanglings)) continue;
                    additionalDanglingElements.add(new DanglingVPMElementDTO((VPMElement)elem, bodyNode));
                }
                this.connectElements((Relation)element, result, bodyNode);
            } else if (element instanceof Relationship) {
                VariableID supplierID = bodyNode.getVariableID(((Relationship)element).getSupplierStr());
                if (!result.containsIndex(supplierID)) {
                    this.evaluateRelationship((Relationship)element, result, bodyNode);
                } else {
                    SearchGraphNode suppliernode = this.getSearchNode(result.getIndex(supplierID));
                    if (suppliernode == null) {
                        String[] context = new String[]{element instanceof SupertypeOf ? "supertypeOf" : "instanceOf", ((Relationship)element).getSupplierStr()};
                        throw new PatternMatcherCompileTimeException("The source '{2}' of the '{1}' relation cannot be resolved", context, (AnnotatedElement)element);
                    }
                    this.evaluateRelationship((Relationship)element, result, bodyNode);
                }
            } else {
                String[] context = new String[]{element.toString()};
                throw new PatternMatcherCompileTimeException("[INTERNAL ERROR] Dangling relation element evaluation failed: {1}", context, (AnnotatedElement)element);
            }
            alreadyProcessedDanglings.add(dto);
        }
        if (additionalDanglingElements.size() != 0) {
            this.evaluateDanglingElements(additionalDanglingElements, result, alreadyProcessedDanglings);
        }
    }

    @Override
    public void connectDanglingRelations(FlattenedPattern result) throws PatternMatcherCompileTimeException {
        if (this.danglingElements.size() != 0) {
            this.evaluateDanglingElements(this.danglingElements, result, new ArrayList<DanglingVPMElementDTO>());
        }
    }

    private void evaluateModelElement(ModelElement rel, FlattenedPattern result, BodyNode bodyNode) {
        NodeTraceabilityElement traceability;
        SearchGraphNode node;
        SearchGraphEdge edge = null;
        VariableID relID = bodyNode.getVariableID(rel);
        if (rel.getType().size() == 0) {
            ConstantSearchGraphNode ent;
            edge = new SearchGraphEdge();
            edge.setVPMEdgeType(EdgeType.INSTANCEOF);
            edge.setWeight(60);
            edge.setOldWeight(60);
            edge.setSource(true);
            EdgeTraceabilityElement edgeTraceability = new EdgeTraceabilityElement(edge, (AnnotatedElement)rel);
            this.traceabilityMapping.put(edge, edgeTraceability);
            if (rel instanceof Entity) {
                if (this.getSearchNode(-1) == null) {
                    ent = new ConstantSearchGraphNode();
                    ent.setName("Entity");
                    ent.setElement("vpm.entity");
                    this.searchNodes.put(-1, ent);
                    ConstantNodeTraceabilityElement traceability2 = new ConstantNodeTraceabilityElement(ent, (AnnotatedElement)rel);
                    this.traceabilityMapping.put(ent, traceability2);
                }
                edge.setSourceNode(this.getSearchNode(-1));
                edge.setName("Entity-ins->" + rel.getName());
            } else {
                if (this.getSearchNode(-2) == null) {
                    ent = new ConstantSearchGraphNode();
                    ent.setName("Relation");
                    ent.setElement("vpm.relation");
                    this.searchNodes.put(-2, ent);
                    ConstantNodeTraceabilityElement traceability3 = new ConstantNodeTraceabilityElement(ent, (AnnotatedElement)rel);
                    this.traceabilityMapping.put(ent, traceability3);
                }
                edge.setSourceNode(this.getSearchNode(-2));
                edge.setName("Relation-ins->" + rel.getName());
            }
        }
        if (result.containsIndex(relID)) {
            if (!this.searchNodes.containsKey(result.getIndex(relID))) {
                node = new VariableSearchGraphNode();
                ((VariableSearchGraphNode)node).setId(result.getIndex(relID));
                node.setName(relID.getFancyName());
                this.searchNodes.put(((VariableSearchGraphNode)node).getId(), node);
                traceability = new VariableNodeTraceabilityElement((VariableSearchGraphNode)node, (AnnotatedElement)rel);
                this.traceabilityMapping.put(node, traceability);
                if (rel instanceof Entity) {
                    ((VariableSearchGraphNode)node).setVpmModelElementType(VPMModelElementType.ENTITY);
                }
                if (rel instanceof Relation) {
                    ((VariableSearchGraphNode)node).setVpmModelElementType(VPMModelElementType.RELATION);
                }
                if (rel.getType().size() == 0) {
                    edge.setTargetNode(node);
                    node.addSource(edge);
                }
            }
        } else if (this.constantNodes.containsKey(rel.getName())) {
            node = new ConstantSearchGraphNode();
            ((ConstantSearchGraphNode)node).setElement(rel.getRealElement());
            node.setName(rel.getRealElement());
            this.searchNodes.put(this.constantNodesNumber, node);
            this.constantNodes.put(node.getName(), this.constantNodesNumber);
            --this.constantNodesNumber;
            traceability = new ConstantNodeTraceabilityElement((ConstantSearchGraphNode)node, (AnnotatedElement)rel);
            this.traceabilityMapping.put(node, traceability);
            if (rel.getType().size() == 0) {
                edge.setTargetNode(node);
                node.addSource(edge);
            }
        }
    }

    private void evaluateRelationship(Relationship rel, FlattenedPattern result, BodyNode bodyNode) {
        EdgeTraceabilityElement inverseEdgeTraceability;
        SearchGraphNode suppliernode = null;
        SearchGraphEdge edge = new SearchGraphEdge();
        SearchGraphEdge invedge = null;
        ModelElement supplier = rel.getSupplier();
        String supplierName = rel.getSupplierStr();
        VariableID supplierID = bodyNode.getVariableID(supplierName);
        String clientName = rel.getClientStr();
        VariableID clientID = bodyNode.getVariableID(clientName);
        VariableSearchGraphNode clientnode = (VariableSearchGraphNode)this.searchNodes.get(result.getIndex(clientID));
        if (result.containsIndex(supplierID)) {
            suppliernode = this.getSearchNode(result.getIndex(supplierID));
            if (suppliernode == null) {
                this.danglingElements.add(new DanglingVPMElementDTO((VPMElement)rel, bodyNode));
                return;
            }
        } else if (this.constantNodes.containsKey(supplierName)) {
            suppliernode = this.getSearchNode(this.constantNodes.get(supplierName));
        } else {
            suppliernode = new ConstantSearchGraphNode();
            ((ConstantSearchGraphNode)suppliernode).setElement(supplier.getRealElement());
            suppliernode.setName(((ConstantSearchGraphNode)suppliernode).getElement());
            this.searchNodes.put(this.constantNodesNumber, suppliernode);
            this.constantNodes.put(suppliernode.getName(), this.constantNodesNumber);
            --this.constantNodesNumber;
            ConstantNodeTraceabilityElement traceability = new ConstantNodeTraceabilityElement((ConstantSearchGraphNode)suppliernode, (AnnotatedElement)supplier);
            this.traceabilityMapping.put(suppliernode, traceability);
        }
        if (rel instanceof TypeOf) {
            edge.setVPMEdgeType(EdgeType.INSTANCEOF);
            edge.setTargetNode(clientnode);
            edge.setWeight(20);
            edge.setOldWeight(20);
            edge.setSource(true);
            edge.setSourceNode(suppliernode);
            edge.setName(String.valueOf(suppliernode.getName()) + "_instanceof_" + clientnode.getName());
            clientnode.addSource(edge);
            if (suppliernode instanceof VariableSearchGraphNode) {
                invedge = new SearchGraphEdge();
                invedge.setVPMEdgeType(EdgeType.INSTANCEOF);
                invedge.setTargetNode(suppliernode);
                invedge.setWeight(40);
                invedge.setOldWeight(40);
                invedge.setSource(false);
                invedge.setSourceNode(clientnode);
                invedge.setName(String.valueOf(suppliernode.getName()) + "_instanceofINV_" + clientnode.getName());
                suppliernode.addSource(invedge);
                edge.setInverseEdge(invedge);
                inverseEdgeTraceability = new EdgeTraceabilityElement(invedge, (AnnotatedElement)rel);
                this.traceabilityMapping.put(invedge, inverseEdgeTraceability);
            }
        } else {
            edge.setVPMEdgeType(EdgeType.SUPERTYPEOF);
            edge.setTargetNode(suppliernode);
            edge.setSourceNode(clientnode);
            edge.setSource(true);
            edge.setWeight(10);
            edge.setOldWeight(10);
            edge.setName(String.valueOf(suppliernode.getName()) + "_supertypeof_" + clientnode.getName());
            suppliernode.addSource(edge);
            invedge = new SearchGraphEdge();
            invedge.setVPMEdgeType(EdgeType.SUPERTYPEOF);
            invedge.setTargetNode(clientnode);
            invedge.setSourceNode(suppliernode);
            invedge.setSource(false);
            invedge.setWeight(20);
            invedge.setOldWeight(20);
            invedge.setName(String.valueOf(suppliernode.getName()) + "_supertypeof_INV" + clientnode.getName());
            clientnode.addSource(invedge);
            edge.setInverseEdge(invedge);
            inverseEdgeTraceability = new EdgeTraceabilityElement(invedge, (AnnotatedElement)rel);
            this.traceabilityMapping.put(invedge, inverseEdgeTraceability);
        }
        EdgeTraceabilityElement edgeTraceability = new EdgeTraceabilityElement(edge, (AnnotatedElement)rel);
        this.traceabilityMapping.put(edge, edgeTraceability);
    }

    @Override
    public void add(PatternReferenceNode prNode, FlattenedPattern result) throws PatternMatcherCompileTimeException {
        PatternNode reference = prNode.getReference();
        List<Term> actualParameters = prNode.getActualParameters();
        BodyNode parent = (BodyNode)prNode.getParent();
        int weight = 20;
        Integer[] parameterMapping = new Integer[actualParameters.size()];
        PatternCallSearchGraphNode patternCallNode = new PatternCallSearchGraphNode();
        int index = result.addVariable(null);
        patternCallNode.setName("PatternCallof_" + reference.getPattern().getName());
        patternCallNode.setId(index);
        patternCallNode.setVpmModelElementType(VPMModelElementType.OPERATION);
        patternCallNode.setPatternNode(reference);
        this.searchNodes.put(patternCallNode.getId(), patternCallNode);
        PatternCallNodeTraceabilityElement patternCallTraceabilityElement = new PatternCallNodeTraceabilityElement(patternCallNode, (AnnotatedElement)prNode.getPatternCall());
        this.traceabilityMapping.put(patternCallNode, patternCallTraceabilityElement);
        if (prNode.getReference() instanceof PatternNodeIncremental) {
            weight = 9;
            SearchGraphEdge edge = null;
            edge = new SearchGraphEdge();
            edge.setVPMEdgeType(EdgeType.PATTERN_CALL_STORAGE);
            edge.setWeight(7);
            edge.setOldWeight(7);
            edge.setSource(true);
            if (this.getSearchNode(-3) == null) {
                ConstantSearchGraphNode ent = new ConstantSearchGraphNode();
                ent.setName("Pattern_Call_Storage_Node");
                ent.setElement("vpm.entity");
                this.searchNodes.put(-3, ent);
            }
            edge.setSourceNode(this.getSearchNode(-3));
            edge.setName("PatternStorage-store->" + patternCallNode.getName());
            edge.setTargetNode(patternCallNode);
            patternCallNode.addSource(edge);
        }
        int i = 0;
        while (i < actualParameters.size()) {
            SearchGraphNode inputNode;
            VariableReference varRef;
            if (actualParameters.get(i) instanceof VariableReference) {
                varRef = (VariableReference)actualParameters.get(i);
                inputNode = null;
                Integer variableIndex = result.getIndex(parent.getVariableID(varRef.getVariable()));
                if (this.searchNodes.containsKey(variableIndex)) {
                    inputNode = this.getSearchNode(variableIndex);
                    parameterMapping[i] = ((VariableSearchGraphNode)inputNode).getId();
                } else {
                    inputNode = new VariableSearchGraphNode();
                    inputNode.setName(parent.getVariableID(varRef.getVariable()).toString());
                    int id = result.getIndex(parent.getVariableID(varRef.getVariable())) != null ? result.getIndex(parent.getVariableID(varRef.getVariable())).intValue() : result.addVariable(parent.getVariableID(varRef.getVariable()));
                    ((VariableSearchGraphNode)inputNode).setId(id);
                    this.searchNodes.put(((VariableSearchGraphNode)inputNode).getId(), inputNode);
                    parameterMapping[i] = id;
                    VariableNodeTraceabilityElement traceability = new VariableNodeTraceabilityElement((VariableSearchGraphNode)inputNode, (AnnotatedElement)varRef);
                    this.traceabilityMapping.put(inputNode, traceability);
                }
            } else {
                String[] context = new String[]{"" + i, prNode.getPatternCall().getCalledPattern().getName()};
                PatternMatcherCompileTimeException e = new PatternMatcherCompileTimeException("The {1}. input parameter in the {2} GT pattern call is not a Variable.", context, (AnnotatedElement)actualParameters.get(i));
                throw e;
            }
            SearchGraphEdge edgePatternCall = new SearchGraphEdge();
            SearchGraphEdge edgePatternCallinverse = new SearchGraphEdge();
            edgePatternCall.setSourceNode(inputNode);
            edgePatternCall.setTargetNode(patternCallNode);
            edgePatternCall.setSource(true);
            edgePatternCall.setWeight(weight);
            edgePatternCall.setOldWeight(weight);
            edgePatternCall.setVPMEdgeType(EdgeType.PATTERN_CALL_PARAMETER);
            edgePatternCall.setName(String.valueOf(inputNode.getName()) + "->" + patternCallNode.getName());
            patternCallNode.addSource(edgePatternCall);
            edgePatternCallinverse.setSourceNode(patternCallNode);
            edgePatternCallinverse.setTargetNode(inputNode);
            edgePatternCallinverse.setSource(false);
            edgePatternCallinverse.setWeight(4);
            edgePatternCallinverse.setOldWeight(4);
            edgePatternCallinverse.setVPMEdgeType(EdgeType.PATTERN_CALL_PARAMETER);
            edgePatternCallinverse.setName(String.valueOf(patternCallNode.getName()) + "->" + inputNode.getName());
            inputNode.addSource(edgePatternCallinverse);
            edgePatternCall.setInverseEdge(edgePatternCallinverse);
            EdgeTraceabilityElement edgeTraceability = new EdgeTraceabilityElement(edgePatternCall, (AnnotatedElement)varRef);
            this.traceabilityMapping.put(edgePatternCall, edgeTraceability);
            EdgeTraceabilityElement inverseEdgeTraceability = new EdgeTraceabilityElement(edgePatternCallinverse, (AnnotatedElement)varRef);
            this.traceabilityMapping.put(edgePatternCallinverse, inverseEdgeTraceability);
            ++i;
        }
        patternCallNode.setInputParameterMapping(parameterMapping);
    }

    @Override
    public GTOperationContext generateGTOperations(Collection<GTElementMapping> gtElementMappings, IModelManager manager, PatternCallSignature[] signatures) throws GTRuleBuildingException {
        this.initSearchGraph();
        ArrayList<IUpdatePlanOperation> manipulationOperations = new ArrayList<IUpdatePlanOperation>();
        ArrayList<ISearchPlanOperation> checkSet = new ArrayList<ISearchPlanOperation>();
        Vector<IUpdatePlanOperation> postSearchPlanOperations = new Vector<IUpdatePlanOperation>();
        ElementManipulationOperation operation = null;
        this.hasOneInConstraint = new HashMap<SearchGraphNode, Boolean>();
        if (gtElementMappings != null) {
            for (GTElementMapping map : gtElementMappings) {
                if (this.searchNodes.containsKey(map.getRhsInputOrderIndex())) {
                    map.setMappingType(GTElementMappingType.KEEP);
                    ((VariableSearchGraphNode)this.getSearchNode(map.getRhsInputOrderIndex())).setInput(true);
                    ((VariableSearchGraphNode)this.getSearchNode(map.getRhsInputOrderIndex())).setChecked(true);
                    continue;
                }
                map.setMappingType(GTElementMappingType.DEL);
                manipulationOperations.add(new DeleteModelElement(manager, map.getRhsInputOrderIndex()));
            }
        }
        int j = 0;
        while (j < signatures.length) {
            if (this.searchNodes.containsKey(j) && this.getSearchNode(j) instanceof VariableSearchGraphNode) {
                VariableSearchGraphNode node = (VariableSearchGraphNode)this.getSearchNode(j);
                if (signatures[j].getParameterMode().equals((Object)ParameterMode.INPUT)) {
                    node.setInput(true);
                    Collection<IUpdatePlanOperation> _temp = GTOperationGenerator.getInputSpecificOperation(node, manager, checkSet);
                    if (_temp != null && _temp.size() > 0) {
                        postSearchPlanOperations.addAll(_temp);
                    }
                } else {
                    node.setInput(false);
                }
            }
            ++j;
        }
        SearchGraphNode[] searchGraphNodeArray = this.searchNodeOrder = this.alg.evaluateSearchPlan(this);
        int n = this.searchNodeOrder.length;
        int node = 0;
        while (node < n) {
            SearchGraphNode node2 = searchGraphNodeArray[node];
            if (node2 instanceof ConstantSearchGraphNode) {
                node2.setChecked(true);
            }
            GTRuleValidator.validateContainment(node2, manager, this.hasOneInConstraint);
            if (!node2.isChecked() && node2.getTreeEdge() != null && !node2.getTreeEdge().isChecked() && (operation = GTOperationGenerator.getModelManipulationOperation((VariableSearchGraphNode)node2, manager, checkSet, (ISearchGraph)this)) != null) {
                manipulationOperations.add(operation);
            }
            for (SearchGraphEdge edge : node2.getSources()) {
                if (!edge.getSourceNode().isChecked() || !edge.getTargetNode().isChecked() || edge.isChecked() || (operation = GTOperationGenerator.getModelManipulationOperation(edge, manager, checkSet, (ISearchGraph)this)) == null) continue;
                manipulationOperations.add(operation);
            }
            ++node;
        }
        boolean noUncheckedOperation = true;
        do {
            noUncheckedOperation = true;
            SearchGraphNode[] searchGraphNodeArray2 = this.searchNodeOrder;
            int n2 = this.searchNodeOrder.length;
            n = 0;
            while (n < n2) {
                SearchGraphNode node3 = searchGraphNodeArray2[n];
                if (!node3.isChecked()) {
                    operation = GTOperationGenerator.getModelManipulationOperation((VariableSearchGraphNode)node3, manager, checkSet, (ISearchGraph)this);
                    if (operation == null) {
                        noUncheckedOperation = false;
                    } else {
                        manipulationOperations.add(operation);
                        node3.setChecked(true);
                    }
                }
                for (SearchGraphEdge edge : node3.getSources()) {
                    if (edge.isChecked() || !edge.getSourceNode().isChecked() || !edge.getTargetNode().isChecked()) continue;
                    operation = GTOperationGenerator.getModelManipulationOperation(edge, manager, checkSet, (ISearchGraph)this);
                    if (operation == null) {
                        noUncheckedOperation = false;
                        continue;
                    }
                    manipulationOperations.add(operation);
                    edge.setChecked(true);
                }
                ++n;
            }
        } while (!noUncheckedOperation);
        if (postSearchPlanOperations.size() != 0) {
            manipulationOperations.addAll(postSearchPlanOperations);
        }
        GTRuleValidator gtRuleValidator = new GTRuleValidator();
        gtRuleValidator.validateOperationPlan(manipulationOperations, checkSet, gtElementMappings, this);
        return new GTOperationContext(null, manipulationOperations, checkSet);
    }

    @Override
    public Collection<SearchPlanOperation> generateSearchPlan(FlattenedPattern pattern, Boolean[] adornment, IModelManager manager) throws PatternMatcherRuntimeException {
        int j = 0;
        while (j < adornment.length) {
            SearchGraphNode node = this.getSearchNode(j);
            if (node instanceof VariableSearchGraphNode) {
                ((VariableSearchGraphNode)node).setInput(adornment[j]);
            }
            ++j;
        }
        this.searchNodeOrder = this.alg.evaluateSearchPlan(pattern.getSearchGraph());
        return VPMPatternOperationGenerator.evaluateVPMOperationPlan(this.searchNodeOrder, new MatchingFrame(pattern), manager);
    }

    @Override
    public AnnotatedElement getGTASMRepresentation(AbstractNode node) {
        return node.getTraceabilityElement().getRepresentativeEMFElement();
    }

    @Override
    public void addTraceabilityElement(SearchGraphEdge edge, EdgeTraceabilityElement element) {
        this.traceabilityMapping.put(edge, element);
    }

    @Override
    public void addTraceabilityElement(SearchGraphNode node, NodeTraceabilityElement element) {
        this.traceabilityMapping.put(node, element);
    }
}

