/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.EdgeConstraintCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class BoundToBoundCheckOperation
extends EdgeConstraintCheckOperation {
    private Integer source;
    private Integer target;
    private SearchGraphEdge edge;

    public BoundToBoundCheckOperation(Integer source, Integer target, SearchGraphEdge edge) {
        this.source = source;
        this.target = target;
        this.edge = edge;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        IModelElement sourceElement = null;
        IModelElement targetElement = null;
        try {
            sourceElement = (IModelElement)frame.getValue(this.source);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.edge.getVPMEdgeType().toString(), frame.getPattern().getSearchGraph().getSearchNode(this.source).getName(), frame.getValue(this.source).getClass().getName()};
            throw new PatternMatcherRuntimeException("Type mismatch: {2} did not evaluate to a model element (entity or relation), but to type {3} instead. Developer's note: error occurred during the '{1}' type check operation.", context, frame.getPattern().getSearchGraph().getSearchNode(this.source).getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            targetElement = (IModelElement)frame.getValue(this.target);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.edge.getVPMEdgeType().toString(), frame.getPattern().getSearchGraph().getSearchNode(this.target).getName(), frame.getValue(this.target).getClass().getName()};
            throw new PatternMatcherRuntimeException("Type mismatch: {2} did not evaluate to a model element (entity or relation), but to type {3} instead. Developer's note: error occurred during the '{1}' type check operation.", context, frame.getPattern().getSearchGraph().getSearchNode(this.target).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (sourceElement == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.source).getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.source).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (targetElement == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.target).getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.target).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && !this.edge.isSource()) {
            return sourceElement.isInstanceOf(targetElement);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && this.edge.isSource()) {
            return targetElement.isInstanceOf(sourceElement);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && !this.edge.isSource()) {
            return targetElement.isSubtypeOf(sourceElement);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && this.edge.isSource()) {
            return sourceElement.isSubtypeOf(targetElement);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && !this.edge.isSource()) {
            return targetElement instanceof IRelation ? ((IRelation)targetElement).getFrom().equals(sourceElement) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && this.edge.isSource()) {
            return sourceElement instanceof IRelation ? ((IRelation)sourceElement).getFrom().equals(targetElement) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.TARGET && !this.edge.isSource()) {
            return targetElement instanceof IRelation ? ((IRelation)targetElement).getTo().equals(sourceElement) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.TARGET && this.edge.isSource()) {
            return sourceElement instanceof IRelation ? ((IRelation)sourceElement).getTo().equals(targetElement) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.IN && !this.edge.isSource()) {
            return sourceElement.getNamespace().compareTo((Object)targetElement) == 0;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.IN && this.edge.isSource()) {
            return targetElement.getNamespace().compareTo((Object)sourceElement) == 0;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.BELOW && !this.edge.isSource()) {
            return sourceElement.isBelowNamespace(targetElement);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.BELOW && this.edge.isSource()) {
            return targetElement.isBelowNamespace(sourceElement);
        }
        String[] context = new String[]{this.edge.getVPMEdgeType().toString(), this.getClass().getSimpleName()};
        throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' type VPM edge related to the '{2}' element is not supported as a check operation.", context, this.edge.getTraceabilityElement().getRepresentativeEMFElement());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source + " -- " + this.edge.getVPMEdgeType().name() + " -> " + this.target;
    }

    @Override
    public String toString(MatchingFrame frame) {
        IModelElement sourceElement = null;
        IModelElement targetElement = null;
        try {
            sourceElement = (IModelElement)frame.getValue(this.source);
        }
        catch (ClassCastException classCastException) {
            return this.toString();
        }
        try {
            targetElement = (IModelElement)frame.getValue(this.target);
        }
        catch (ClassCastException classCastException) {
            return this.toString();
        }
        if (sourceElement == null) {
            return this.toString();
        }
        if (targetElement == null) {
            return this.toString();
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF) {
            return String.valueOf(this.getClass().getSimpleName()) + " : " + this.edge.getTargetNode().getName() + " -- " + this.edge.getVPMEdgeType().name() + " -> " + this.edge.getSourceNode().getName();
        }
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.edge.getSourceNode().getName() + " -- " + this.edge.getVPMEdgeType().name() + " -> " + this.edge.getTargetNode().getName();
    }

    @Override
    public void calculateSidewaysPassedVariables(Set<Integer> variables) {
        variables.add(this.source);
        variables.add(this.target);
    }

    @Override
    public void calculateLocalVariables(Set<Integer> variables) {
        variables.add(this.source);
        variables.add(this.target);
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.edge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

