/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.EngineManager;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.RetePatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;

public class ReteMatcherHelper {
    public static Collection<Tuple> getMatchSet(IFramework fw, GTPattern pattern) throws RetePatternBuildException {
        int size = pattern.getSymParameters().size();
        Object[] inputMapping = new Object[size];
        boolean[] fixed = new boolean[size];
        int i = 0;
        while (i < size) {
            inputMapping[i] = null;
            fixed[i] = false;
            ++i;
        }
        return ReteMatcherHelper.getMatchSet(fw, pattern, inputMapping, fixed);
    }

    public static Collection<Tuple> getMatchSet(IFramework fw, GTPattern pattern, Object[] parameters) throws RetePatternBuildException {
        int size = parameters.length;
        boolean[] fixed = new boolean[size];
        int i = 0;
        while (i < size) {
            fixed[i] = parameters[i] != null;
            ++i;
        }
        return ReteMatcherHelper.getMatchSet(fw, pattern, parameters, fixed);
    }

    public static Collection<Tuple> getMatchSet(IFramework fw, GTPattern pattern, Map<String, Object> parameters) throws RetePatternBuildException {
        EList symParameters = pattern.getSymParameters();
        int size = symParameters.size();
        Object[] inputMapping = new Object[size];
        boolean[] fixed = new boolean[size];
        int i = 0;
        while (i < size) {
            String key = ((PatternVariable)symParameters.get(i)).getName();
            fixed[i] = parameters.containsKey(key);
            inputMapping[i] = fixed[i] ? parameters.get(key) : null;
            ++i;
        }
        return ReteMatcherHelper.getMatchSet(fw, pattern, inputMapping, fixed);
    }

    private static Collection<Tuple> getMatchSet(IFramework fw, GTPattern pattern, Object[] inputMapping, boolean[] fixed) throws RetePatternBuildException {
        ReteEngine<GTPattern> reteEngine = EngineManager.getInstance().getReteEngine(fw);
        RetePatternMatcher patternMatcher = reteEngine.accessMatcher((Object)pattern);
        return patternMatcher.matchAll(inputMapping, fixed);
    }
}

