/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.ASMFunctionContent;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.VPMContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.AbstractEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;

class GTASMTermEvaluator
extends AbstractEvaluator {
    protected Term term;
    protected IPatternMatcherContext<?> context;
    protected Map<String, Integer> variableIndices;
    protected Map<String, String> variableEquivalence;

    public GTASMTermEvaluator(IPatternMatcherContext<?> context, Term term, Map<String, Integer> variableIndices, Map<String, String> variableEquivalence) {
        this.context = context;
        this.term = term;
        this.variableEquivalence = variableEquivalence;
        this.variableIndices = variableIndices;
    }

    public Object doEvaluate(Tuple tuple) throws ViatraTransformationException {
        TermCheckExecutionEnvironment env = new TermCheckExecutionEnvironment(this, tuple);
        return TermEvaluator.getInstance().evaluate((IExecutionEnvironment)env, this.term);
    }

    public int findVariableIndexByName(String name) {
        String equivalentName = this.variableEquivalence.get(name);
        Integer integer = this.variableIndices.get(equivalentName);
        return integer;
    }

    public IPatternMatcherContext<?> getContext() {
        return this.context;
    }

    class TermCheckExecutionEnvironment
    implements IExecutionEnvironment {
        IFramework framework;
        GTASMTermEvaluator evaluator;
        Tuple ps;
        Set<Tuple> traces;

        public TermCheckExecutionEnvironment(GTASMTermEvaluator evaluator, Tuple ps) {
            this.framework = ((VPMContext)evaluator.getContext()).getFramework();
            this.evaluator = evaluator;
            this.ps = ps;
            this.traces = new HashSet<Tuple>();
        }

        public Object getValueOfASMFunction(ASMFunction asmFunction, EList<Object> location) {
            Object[] traceElements = new Object[location.size() + 1];
            int k = 0;
            traceElements[k++] = asmFunction;
            for (Object o : location) {
                traceElements[k++] = o;
            }
            FlatTuple trace = new FlatTuple(traceElements);
            this.traces.add((Tuple)trace);
            HashMap af = (HashMap)ASMFunctionContent.getInstance().get((Object)asmFunction);
            if (af == null) {
                return null;
            }
            return af.get(location);
        }

        public Object getVariableValue(Variable variable) {
            String varName = variable.getName();
            int index = this.evaluator.findVariableIndexByName(varName);
            return this.ps.get(index);
        }

        public Set<Tuple> getTraces() {
            return this.traces;
        }

        public void addVariable(Variable key, Object value) throws ViatraTransformationException {
            throw new UnsupportedOperationException();
        }

        public void fetchVariableVariations(HashMap<Variable, Vector<Object>> possibleVariableValues, Term termToBeEvaluated) {
            throw new UnsupportedOperationException();
        }

        public IFramework getFramework() {
            return this.framework;
        }

        public Map<Variable, Object> getVariableValues() {
            throw new UnsupportedOperationException();
        }

        public void setVariableValue(Variable variable, Object value) throws ViatraTransformationException {
            throw new UnsupportedOperationException();
        }

        public void updateASMFunction(ASMFunction asmFunction, EList<Object> location, Object value) throws ViatraTransformationException {
            throw new UnsupportedOperationException();
        }
    }
}

