/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.hardwired.HardwiredDirectInstantiation;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.hardwired.HardwiredTransitiveClosure;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.IRetePatternBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherStringTypedContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.PatternScaffold;
import org.eclipse.viatra2.gtasm.support.helper.GTASMHelper;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.GTASMElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

public class SimpleReteBuilder<StubHandle, Collector>
implements IRetePatternBuilder<GTPattern, StubHandle, Collector> {
    protected GTASMBuildable<StubHandle, Collector> baseBuildable;
    protected IPatternMatcherStringTypedContext<GTPattern> context;

    public SimpleReteBuilder(GTASMBuildable<StubHandle, Collector> baseBuildable, IPatternMatcherStringTypedContext<GTPattern> context) {
        this.baseBuildable = baseBuildable;
        this.context = context;
    }

    public void refresh() {
        this.baseBuildable.reinitialize();
    }

    public Collector construct(GTPattern gtPattern) throws RetePatternBuildException {
        Object production = this.baseBuildable.putOnTab(gtPattern).patternCollector(gtPattern);
        Map incrementalAnnotation = GTASMHelper.extractLowerCaseRuntimeAnnotation((GTASMElement)gtPattern, (String)"@Incremental");
        if (incrementalAnnotation != null && incrementalAnnotation.get("reinterpret") != null) {
            if (((String)incrementalAnnotation.get("reinterpret")).equals("directInstantiation")) {
                return (Collector)new HardwiredDirectInstantiation<StubHandle, Object>(this.baseBuildable, (IPatternMatcherContext<GTPattern>)this.context, gtPattern, production).run();
            }
            if (((String)incrementalAnnotation.get("reinterpret")).equals("transitiveClosure")) {
                String ofPatternName = (String)incrementalAnnotation.get("ofPattern");
                EList gtPatternDefinitions = gtPattern.getContainer().getGtPatternDefinitions();
                for (GTPattern ofPattern : gtPatternDefinitions) {
                    if (!ofPattern.getName().equals(ofPatternName)) continue;
                    return (Collector)new HardwiredTransitiveClosure<StubHandle, Object>(this.baseBuildable, (IPatternMatcherContext<GTPattern>)this.context, gtPattern, ofPattern, production).run();
                }
                throw new RetePatternBuildException("Sibling pattern not found: {1}", new String[]{ofPatternName}, (Object)gtPattern);
            }
            throw new RetePatternBuildException("Unsupported reinterpret annotation: {1}", new String[]{(String)incrementalAnnotation.get("reinterpret")}, (Object)gtPattern);
        }
        return (Collector)new PatternScaffold(this, gtPattern, production).run();
    }

    public HashMap<Object, Integer> getPosMapping(GTPattern gtPattern) {
        HashMap<Object, Integer> posMapping = new HashMap<Object, Integer>();
        int l = 0;
        for (Object o : gtPattern.getSymParameters()) {
            posMapping.put(o, l++);
        }
        return posMapping;
    }

    public IPatternMatcherStringTypedContext<GTPattern> getContext() {
        return this.context;
    }
}

