/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.util.Options;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.PatternScaffold;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.SimpleReteBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.HyperEdgeClass;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternNodeBase;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;

public class BodyScaffold<StubHandle, Collector> {
    protected SimpleReteBuilder<StubHandle, Collector> builder;
    protected GTASMBuildable<StubHandle, Collector> buildable;
    protected PatternScaffold<StubHandle, Collector> patternScaffold;
    protected GTPatternBody body;
    protected Collector collector;
    protected PatternGraph pGraph;
    protected Set<PatternNode> visitedNodes = new HashSet<PatternNode>();
    protected Set<PatternEdge> visitedEdges = new HashSet<PatternEdge>();
    protected Set<PatternEdge> edgeQueue = new TreeSet<PatternEdge>();

    public BodyScaffold(SimpleReteBuilder<StubHandle, Collector> builder, GTASMBuildable<StubHandle, Collector> buildable, PatternScaffold<StubHandle, Collector> patternScaffold, GTPatternBody body, Collector collector) {
        this.builder = builder;
        this.buildable = buildable;
        this.patternScaffold = patternScaffold;
        this.body = body;
        this.collector = collector;
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws RetePatternBuildException {
        void var6_8;
        this.builder.getContext().logDebug("patternbody build started");
        this.pGraph = new PatternGraph(this.patternScaffold.getGtPattern(), this.body, this.builder);
        for (PatternEdge edge : this.pGraph.pEdges) {
            this.edgeQueue.add(edge);
        }
        int constants = this.pGraph.getConstantValues().size();
        Object[] constantValues = new Object[constants];
        Object[] constantNames = new PatternNode[constants];
        int currentConstant = 0;
        for (Map.Entry<PatternNode, Object> entry : this.pGraph.getConstantValues().entrySet()) {
            constantNames[currentConstant] = entry.getKey();
            constantValues[currentConstant] = entry.getValue();
            ++currentConstant;
        }
        Object[] objectArray = constantNames;
        int n = constantNames.length;
        boolean n2 = false;
        while (var6_8 < n) {
            PatternNode constant = objectArray[var6_8];
            this.bindPNode(constant);
            ++var6_8;
        }
        Stub stub = this.buildable.buildStartStub(constantValues, constantNames);
        while (!this.edgeQueue.isEmpty()) {
            void var8_17;
            PatternEdge patternEdge = this.edgeQueue.iterator().next();
            this.edgeQueue.remove(patternEdge);
            this.visitedEdges.add(patternEdge);
            if (patternEdge.isUnsafeQuantification()) {
                String[] args = new String[]{patternEdge.originText, this.patternScaffold.getGtPattern().getName()};
                String string = "The incremental engine currently does not support unresolvable variables. Keep also in mind that certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters - [{1}] in [{2}]";
                throw new RetePatternBuildException(string, args, (Object)this.patternScaffold.getGtPattern());
            }
            if (patternEdge.isUnsafeTypeless()) {
                String[] args = new String[]{patternEdge.originText, this.patternScaffold.getGtPattern().toString()};
                String string = "[INTERNAL ERROR] Non-typesafe check operation attempted by incremental pattern matcher without matching types - [{1}] in [{2}]";
                throw new RetePatternBuildException(string, args, (Object)this.patternScaffold.getGtPattern());
            }
            int[] nArray = patternEdge.conveysTypeInformationIndices();
            int n3 = nArray.length;
            boolean bl = false;
            while (var8_17 < n3) {
                int index = nArray[var8_17];
                this.expressTypeOnPNode(patternEdge.nodes.get(index));
                ++var8_17;
            }
            if (patternEdge.edgeClass.isJoinBased()) {
                int index;
                int oldCalibrationSize = stub.getVariablesTuple().getSize();
                int n4 = patternEdge.degreeOfBindingWithMultiplicity;
                Object primaryIndices = new int[n4];
                int[] sideIndices = new int[n4];
                int k = 0;
                int i = 0;
                while (i < patternEdge.nodes.size()) {
                    PatternNodeBase oldNode = patternEdge.nodes.get(i);
                    if (patternEdge.boundNodes.contains(oldNode)) {
                        primaryIndices[k] = (Integer)stub.getVariablesIndex().get(oldNode);
                        sideIndices[k] = i;
                        ++k;
                    }
                    ++i;
                }
                int derivedValueIndex = patternEdge.edgeClass == HyperEdgeClass.COUNT_PATTERN_CALL ? patternEdge.nodes.size() - 1 : -1;
                Stub sideStub = this.extractSideStub(patternEdge);
                HashSet<PatternNode> mapped = new HashSet<PatternNode>();
                LinkedList<Integer> unmapped = new LinkedList<Integer>();
                HashMap<PatternNode, LinkedList<Integer>> occurences = new HashMap<PatternNode, LinkedList<Integer>>();
                Object object = sideIndices;
                int n5 = sideIndices.length;
                int n6 = 0;
                while (n6 < n5) {
                    index = object[n6];
                    mapped.add(patternEdge.nodes.get(index));
                    ++n6;
                }
                index = 0;
                while (index < patternEdge.nodes.size()) {
                    LinkedList<Integer> indices;
                    PatternNode newNode = patternEdge.nodes.get(index);
                    if (newNode.isTouched && mapped.add(newNode)) {
                        unmapped.addLast(index);
                    }
                    if ((indices = (LinkedList<Integer>)occurences.get(newNode)) == null) {
                        indices = new LinkedList<Integer>();
                        occurences.put(newNode, indices);
                    }
                    indices.add(index);
                    ++index;
                }
                int[] complementerIndices = new int[unmapped.size()];
                int l = 0;
                object = unmapped.iterator();
                while (object.hasNext()) {
                    Integer integer = (Integer)object.next();
                    complementerIndices[l++] = integer;
                }
                TupleMask complementer = new TupleMask(complementerIndices, patternEdge.nodes.size());
                for (Collection toBeChecked : occurences.values()) {
                    if (toBeChecked.size() > 1 && toBeChecked.contains(derivedValueIndex)) {
                        toBeChecked.remove(derivedValueIndex);
                    }
                    if (toBeChecked.size() <= 1) continue;
                    int[] indices = new int[toBeChecked.size()];
                    int m = 0;
                    for (Integer index2 : toBeChecked) {
                        indices[m++] = index2;
                    }
                    sideStub = this.buildable.buildEqualityChecker(sideStub, indices);
                }
                TupleMask primaryMask = new TupleMask((int[])primaryIndices, stub.getVariablesTuple().getSize());
                TupleMask effectiveSideMask = new TupleMask(sideIndices, patternEdge.nodes.size());
                if (patternEdge.edgeClass != HyperEdgeClass.COUNT_PATTERN_CALL) {
                    stub = this.buildable.buildBetaNode(stub, sideStub, primaryMask, effectiveSideMask, complementer, patternEdge.edgeClass == HyperEdgeClass.NEGATIVE_PATTERN_CALL);
                } else {
                    Integer resultPositionInSignature = null;
                    int i2 = sideIndices.length - 1;
                    while (i2 >= 0) {
                        if (sideIndices[i2] == derivedValueIndex) {
                            resultPositionInSignature = i2;
                            break;
                        }
                        --i2;
                    }
                    TupleMask originalSideMask = resultPositionInSignature == null ? effectiveSideMask : TupleMask.omit((int)resultPositionInSignature, (int)effectiveSideMask.indices.length).transform(effectiveSideMask);
                    stub = resultPositionInSignature != null ? this.buildable.buildCountCheckBetaNode(stub, sideStub, primaryMask, originalSideMask, resultPositionInSignature) : this.buildable.buildCounterBetaNode(stub, sideStub, primaryMask, originalSideMask, complementer, patternEdge.nodes.get(patternEdge.nodes.size() - 1));
                }
                LinkedList<PatternNode> newNodes = new LinkedList<PatternNode>(patternEdge.unboundNodes);
                for (PatternNode currentNode : newNodes) {
                    this.bindPNode(currentNode);
                }
                if (Options.injectivityStrategy != Options.InjectivityStrategy.EAGER) continue;
                stub = this.constructInjectivityCheckers(stub, oldCalibrationSize);
                continue;
            }
            HashMap<String, Integer> variableIndices = new HashMap<String, Integer>();
            for (PatternNodeBase patternNodeBase : patternEdge.nodes) {
                Integer index = (Integer)stub.getVariablesIndex().get(patternNodeBase);
                variableIndices.put(patternNodeBase.name, index);
            }
            Integer n7 = patternEdge.extra == null ? null : (Integer)stub.getVariablesIndex().get(patternEdge.extra);
            stub = this.buildable.buildGTASMTermChecker((Term)patternEdge.supplierKey, (Map<String, Integer>)variableIndices, (Map<String, String>)this.pGraph.variableEquivalence, n7, (Stub<StubHandle>)stub);
        }
        if (Options.injectivityStrategy == Options.InjectivityStrategy.LAZY) {
            stub = this.constructInjectivityCheckers(stub, 0);
        }
        for (PatternNodeBase patternNodeBase : this.pGraph.pNodeByName.values()) {
            if (this.visitedNodes.contains(patternNodeBase) || !patternNodeBase.isTouched) continue;
            String[] stringArray = new String[]{patternNodeBase.name, this.patternScaffold.getGtPattern().getName()};
            String msg = "Pattern Graph Search terminated incompletely, pattern variable {1} in pattern {2} could not be reached";
            throw new RetePatternBuildException(msg, stringArray, (Object)this.patternScaffold.getGtPattern());
        }
        int n8 = this.patternScaffold.getGtPattern().getSymParameters().size();
        int[] tI = new int[n8];
        int n9 = stub.getVariablesTuple().getSize();
        int i = 0;
        while (i < n8) {
            PatternVariable variable = (PatternVariable)this.patternScaffold.getGtPattern().getSymParameters().get(i);
            PatternNode pNode = this.pGraph.getPNode((Variable)variable);
            tI[i] = (Integer)stub.getVariablesIndex().get(pNode);
            ++i;
        }
        TupleMask trim = new TupleMask(tI, n9);
        Stub trimmer = this.buildable.buildTrimmer(stub, trim);
        this.buildable.buildConnection(trimmer, this.collector);
    }

    protected Stub<StubHandle> constructInjectivityCheckers(Stub<StubHandle> stub, int oldCalibrationSize) {
        int newCalibrationSize = stub.getVariablesTuple().getSize();
        Stub accumulator = stub;
        int subject = oldCalibrationSize;
        while (subject < newCalibrationSize) {
            PatternNodeBase newNode = (PatternNodeBase)stub.getVariablesTuple().get(subject);
            if (!newNode.isExemptFromInjectivity()) {
                boolean injective = this.patternScaffold.getGtPattern().isDistinctMatching();
                Set<PatternNode> explicit = this.pGraph.explicitInequality.get(newNode);
                Set<PatternNode> toBeOmitted = this.pGraph.permittableEquality.get(newNode);
                LinkedList<Integer> toBeChecked = new LinkedList<Integer>();
                int j = 0;
                while (j < subject) {
                    PatternNodeBase oldNode = (PatternNodeBase)stub.getVariablesTuple().get(j);
                    if (!oldNode.isVirtual() && !toBeOmitted.contains(oldNode) && (injective || explicit.contains(oldNode))) {
                        toBeChecked.add(j);
                    }
                    ++j;
                }
                if (!toBeChecked.isEmpty()) {
                    int[] indices = new int[toBeChecked.size()];
                    int l = 0;
                    for (Integer index : toBeChecked) {
                        indices[l++] = index;
                    }
                    accumulator = this.buildable.buildInjectivityChecker(accumulator, subject, indices);
                }
            }
            ++subject;
        }
        return accumulator;
    }

    protected Stub<StubHandle> extractSideStub(PatternEdge edge) throws RetePatternBuildException {
        FlatTuple nodes = new FlatTuple(edge.nodes.toArray());
        Object supplierKey = edge.supplierKey;
        switch (edge.edgeClass) {
            case TYPE_UNARY: {
                return this.buildable.unaryTypeStub((Tuple)nodes, supplierKey);
            }
            case TYPE_TERNARY_EDGE: {
                return this.buildable.ternaryEdgeTypeStub((Tuple)nodes, supplierKey);
            }
            case TYPE_BINARY_EDGE: {
                return this.buildable.binaryEdgeTypeStub((Tuple)nodes, supplierKey);
            }
            case CONTAINMENT_DIRECT: {
                return this.buildable.containmentDirectStub((Tuple)nodes);
            }
            case CONTAINMENT_TRANSITIVE: {
                return this.buildable.containmentTransitiveStub((Tuple)nodes);
            }
            case GENERALIZATION_DIRECT: {
                return this.buildable.generalizationDirectStub((Tuple)nodes);
            }
            case GENERALIZATION_TRANSITIVE: {
                return this.buildable.generalizationTransitiveStub((Tuple)nodes);
            }
            case INSTANTIATION_DIRECT: {
                return this.buildable.instantiationDirectStub((Tuple)nodes);
            }
            case INSTANTIATION_TRANSITIVE: {
                return this.buildable.instantiationTransitiveStub((Tuple)nodes);
            }
            case PATTERN_CALL: 
            case NEGATIVE_PATTERN_CALL: 
            case COUNT_PATTERN_CALL: {
                return this.buildable.patternCallStub((Tuple)nodes, (GTPattern)supplierKey);
            }
            case CHECK_EXPRESSION: {
                String[] args = new String[]{edge.edgeClass.toString()};
                String msg = "Cannot build standard checker, no supplier for this edge class: {1}";
                throw new RetePatternBuildException(msg, args, (Object)this.patternScaffold.getGtPattern());
            }
        }
        String[] args1 = new String[]{edge.edgeClass.toString()};
        String msg1 = "No such HyperEdgeClass: {1}";
        throw new RetePatternBuildException(msg1, args1, (Object)this.patternScaffold.getGtPattern());
    }

    protected void bindPNode(PatternNode currentNode) {
        if (!this.visitedNodes.contains(currentNode)) {
            this.visitedNodes.add(currentNode);
            for (PatternEdge e : this.pGraph.getEdgeList(currentNode)) {
                this.edgeQueue.remove(e);
                e.bindNode(currentNode);
                if (this.visitedEdges.contains(e)) continue;
                this.edgeQueue.add(e);
            }
        }
    }

    protected void expressTypeOnPNode(PatternNodeBase currentNode) {
        --currentNode.lingeringTypeInfoCounter;
        for (PatternEdge e : this.pGraph.getEdgeList(currentNode)) {
            if (!e.isUnsafeTypeless()) continue;
            this.edgeQueue.remove(e);
            --e.totalLingeringTypeInfoCounter;
            if (this.visitedEdges.contains(e)) continue;
            this.edgeQueue.add(e);
        }
    }
}

