/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.HyperEdgeClass;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternNodeBase;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.FunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ModelElementQuery;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.ElementReference;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;

class PatternEdge
implements Comparable<PatternEdge> {
    public PatternGraph pGraph;
    public String originText;
    public Object extra;
    public List<PatternNode> nodes;
    public Map<PatternNode, Integer> multiplicity;
    public Set<PatternNode> boundNodes;
    public Set<PatternNode> unboundNodes;
    public int degreeOfFreedom;
    public int degreeOfFreedomWithMultiplicity;
    public int degreeOfBinding;
    public int degreeOfBindingWithMultiplicity;
    public int totalLingeringTypeInfoCounter;
    public Map<PatternNode, Integer> invertedIndex;
    public HyperEdgeClass edgeClass;
    public Object supplierKey;

    public PatternEdge(PatternGraph pGraph, Entity entity, Object typeObj) {
        this.pGraph = pGraph;
        this.originText = entity.toString();
        this.extra = null;
        this.supplierKey = typeObj;
        this.edgeClass = HyperEdgeClass.TYPE_UNARY;
        PatternNode[] nodes = new PatternNode[]{pGraph.getPNode((ModelElement)entity)};
        this.nodes = Arrays.asList(nodes);
    }

    public PatternEdge(PatternGraph pGraph, Relation rel, Object typeObj) {
        this.pGraph = pGraph;
        this.originText = rel.toString();
        this.extra = null;
        this.supplierKey = typeObj;
        if (pGraph.builder.getContext().edgeInterpretation() == IPatternMatcherContext.EdgeInterpretation.TERNARY) {
            this.edgeClass = HyperEdgeClass.TYPE_TERNARY_EDGE;
            PatternNode[] nodes = new PatternNode[]{pGraph.getPNode((ModelElement)rel), pGraph.getPNode(rel.getFromStr()), pGraph.getPNode(rel.getToStr())};
            this.nodes = Arrays.asList(nodes);
        } else {
            this.edgeClass = HyperEdgeClass.TYPE_BINARY_EDGE;
            PatternNode[] nodes = new PatternNode[]{pGraph.getPNode(rel.getFromStr()), pGraph.getPNode(rel.getToStr())};
            this.nodes = Arrays.asList(nodes);
        }
    }

    public PatternEdge(PatternGraph pGraph, PatternNode parent, PatternNode child, HyperEdgeClass relationshipClass) {
        this.pGraph = pGraph;
        this.originText = relationshipClass.toString();
        this.extra = null;
        this.edgeClass = relationshipClass;
        this.supplierKey = "";
        PatternNode[] nodes = new PatternNode[]{parent, child};
        this.nodes = Arrays.asList(nodes);
    }

    public PatternEdge(PatternGraph pGraph, GTPatternCall call, boolean negative) throws RetePatternBuildException {
        boolean count;
        this.pGraph = pGraph;
        this.originText = call.toString();
        boolean bl = count = call.getMatchCounter() != null;
        if (!count) {
            this.edgeClass = negative ? HyperEdgeClass.NEGATIVE_PATTERN_CALL : HyperEdgeClass.PATTERN_CALL;
            this.extra = null;
        } else if (!negative) {
            this.edgeClass = HyperEdgeClass.COUNT_PATTERN_CALL;
            this.extra = call.getMatchCounter().getVariableReference().getVariable();
        } else {
            String[] context = new String[]{call.getCalledPattern().getName(), pGraph.gtPattern.getName(), call.getMatchCounter().getVariableReference().getVariable().getName()};
            throw new RetePatternBuildException("Negative pattern calls cannot count matches: incomprehensible negative call to pattern {1} in the body of pattern {2} with matches accumulated in {3}", context, (Object)pGraph.gtPattern);
        }
        this.supplierKey = call.getCalledPattern();
        int paramNum = call.getActualParameters().size();
        PatternNode[] nodes = new PatternNode[count ? paramNum + 1 : paramNum];
        int i = 0;
        while (i < paramNum) {
            PatternNode paramNode;
            Object actualParam = call.getActualParameters().get(i);
            if (actualParam instanceof VariableReference) {
                VariableReference paramVar = (VariableReference)actualParam;
                nodes[i] = paramNode = pGraph.getPNode(paramVar.getVariable());
            } else if (actualParam instanceof Constant) {
                Constant constant = (Constant)actualParam;
                nodes[i] = paramNode = pGraph.newConstant(constant);
            } else if (actualParam instanceof ElementReference) {
                ElementReference reference = (ElementReference)actualParam;
                nodes[i] = paramNode = pGraph.newConstant(reference);
            } else {
                Term term = (Term)actualParam;
                nodes[i] = paramNode = pGraph.substituteTerm(term);
            }
            ++i;
        }
        if (count) {
            nodes[paramNum] = pGraph.getPNode((Variable)this.extra);
        }
        if (!negative && !count && call.getCalledPattern().isDistinctMatching()) {
            boolean safe = true;
            for (Object o : call.getCalledPattern().getPatternBodies()) {
                boolean bl2 = safe = safe && ((GTPatternBody)o).getVariableAssignments().isEmpty();
            }
            if (safe) {
                PatternNode[] patternNodeArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    PatternNode pNode = patternNodeArray[n2];
                    pGraph.permittableEquality.get(pNode).addAll(Arrays.asList(nodes));
                    ++n2;
                }
            }
        }
        if (count) {
            nodes[nodes.length - 1].makeExemptFromInjectivity();
        }
        this.nodes = Arrays.asList(nodes);
    }

    public PatternEdge(PatternGraph pGraph, Term expression, PatternNode equalsTo) throws RetePatternBuildException {
        this.pGraph = pGraph;
        this.originText = expression.toString();
        this.extra = equalsTo;
        this.edgeClass = HyperEdgeClass.CHECK_EXPRESSION;
        this.supplierKey = expression;
        HashSet<PatternNode> affected = new HashSet<PatternNode>();
        LinkedList<Term> termQueue = new LinkedList<Term>();
        termQueue.add(expression);
        while (termQueue.size() > 0) {
            Term term = (Term)termQueue.removeFirst();
            if (term instanceof VariableReference) {
                VariableReference termVar = (VariableReference)term;
                PatternNode termNode = pGraph.getPNode(termVar.getVariable());
                affected.add(termNode);
                continue;
            }
            if (term instanceof FunctionInvocation) {
                FunctionInvocation fi = (FunctionInvocation)term;
                for (Object o : fi.getActualParameters()) {
                    termQueue.addFirst((Term)o);
                }
                continue;
            }
            if (term instanceof ModelElementQuery) {
                ModelElementQuery meq = (ModelElementQuery)term;
                termQueue.addFirst(meq.getArgument());
                continue;
            }
            if (!(term instanceof GTPatternCall)) continue;
            GTPatternCall pc = (GTPatternCall)term;
            String[] errorData = new String[]{pc.getCalledPattern().getFqn(), pGraph.gtPattern.getFqn()};
            String message = "Offending call to pattern {1} in enclosing pattern {2}. The incremental pattern matcher does not support GT Pattern calls in terms embedded into GT Patterns; please use a 'find' clause directly in the pattern body.";
            throw new RetePatternBuildException(message, errorData, (Object)term);
        }
        if (equalsTo != null) {
            affected.add(equalsTo);
        }
        int nodeNum = affected.size();
        PatternNode[] nodes = new PatternNode[nodeNum];
        for (PatternNode pNode : affected) {
            nodes[--nodeNum] = pNode;
        }
        this.nodes = Arrays.asList(nodes);
    }

    public void touchQuantifiedNodes() {
        int[] nArray = this.touchingIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.nodes.get((int)i).isTouched = true;
            ++n2;
        }
    }

    public void connectNodes() {
        this.boundNodes = new HashSet<PatternNode>();
        this.unboundNodes = new HashSet<PatternNode>();
        this.multiplicity = new HashMap<PatternNode, Integer>();
        this.degreeOfFreedom = 0;
        this.degreeOfFreedomWithMultiplicity = 0;
        this.degreeOfBinding = 0;
        this.degreeOfBindingWithMultiplicity = 0;
        this.invertedIndex = new HashMap<PatternNode, Integer>();
        int i = 0;
        while (i < this.nodes.size()) {
            PatternNode node = this.nodes.get(i);
            this.invertedIndex.put(node, i);
            this.pGraph.edgeList.get(node).add(this);
            if (!this.multiplicity.containsKey(node)) {
                this.multiplicity.put(node, 0);
            }
            this.multiplicity.put(node, this.multiplicity.get(node) + 1);
            if (!this.edgeClass.touchSensitive() || node.isTouched) {
                ++this.degreeOfFreedomWithMultiplicity;
                if (this.unboundNodes.add(node)) {
                    ++this.degreeOfFreedom;
                }
            }
            ++i;
        }
    }

    public void bindNode(PatternNode node) {
        if (this.unboundNodes.contains(node)) {
            this.boundNodes.add(node);
            this.unboundNodes.remove(node);
            --this.degreeOfFreedom;
            this.degreeOfFreedomWithMultiplicity -= this.multiplicity.get(node).intValue();
            ++this.degreeOfBinding;
            this.degreeOfBindingWithMultiplicity += this.multiplicity.get(node).intValue();
        }
    }

    public boolean isBound() {
        return this.degreeOfFreedom == 0;
    }

    private boolean isFullyTyped() {
        return this.totalLingeringTypeInfoCounter == 0;
    }

    public boolean isUnsafe() {
        return this.isUnsafeQuantification() || this.isUnsafeTypeless();
    }

    public boolean isUnsafeQuantification() {
        int[] nArray = this.bindRequiredIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (this.unboundNodes.contains(this.nodes.get(i))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isUnsafeTypeless() {
        return this.edgeClass.allTypeInfoRequired() && !this.isFullyTyped();
    }

    public boolean isJoinBased() {
        return this.edgeClass.isJoinBased();
    }

    int[] touchingIndices() {
        switch (this.edgeClass) {
            case NEGATIVE_PATTERN_CALL: 
            case CHECK_EXPRESSION: {
                return HyperEdgeClass.iEmpty;
            }
            case COUNT_PATTERN_CALL: {
                return HyperEdgeClass.iOne(this.nodes.size() - 1);
            }
        }
        return HyperEdgeClass.iAll(this.nodes.size());
    }

    int[] bindRequiredIndices() {
        switch (this.edgeClass) {
            case NEGATIVE_PATTERN_CALL: 
            case CHECK_EXPRESSION: {
                return HyperEdgeClass.iAll(this.nodes.size());
            }
            case COUNT_PATTERN_CALL: {
                return HyperEdgeClass.iAll(this.nodes.size() - 1);
            }
        }
        return HyperEdgeClass.iEmpty;
    }

    public int[] conveysTypeInformationIndices() {
        switch (this.edgeClass) {
            case TYPE_UNARY: 
            case TYPE_TERNARY_EDGE: 
            case TYPE_BINARY_EDGE: 
            case PATTERN_CALL: {
                return HyperEdgeClass.iAll(this.nodes.size());
            }
            case INSTANTIATION_DIRECT: 
            case INSTANTIATION_TRANSITIVE: {
                return HyperEdgeClass.iSecond;
            }
        }
        return HyperEdgeClass.iEmpty;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof PatternEdge) {
            PatternEdge other = (PatternEdge)arg0;
            if (this.edgeClass != other.edgeClass) {
                return false;
            }
            if (this.originText != null) {
                return this.originText.equals(other.originText);
            }
            return this.nodes.equals(other.nodes) && this.supplierKey.equals(other.supplierKey);
        }
        return false;
    }

    @Override
    public int compareTo(PatternEdge other) {
        if (this.isUnsafe() ^ other.isUnsafe()) {
            if (this.isUnsafe()) {
                return 1;
            }
            return -1;
        }
        if (this.isBound() ^ other.isBound()) {
            if (this.isBound()) {
                return -1;
            }
            return 1;
        }
        if (this.degreeOfBinding != other.degreeOfBinding) {
            return -1 * (this.degreeOfBinding - other.degreeOfBinding);
        }
        if (this.degreeOfFreedom != other.degreeOfFreedom) {
            return this.degreeOfFreedom - other.degreeOfFreedom;
        }
        if (this.nodes.size() != other.nodes.size()) {
            return -1 * (this.nodes.size() - other.nodes.size());
        }
        int i = 0;
        while (i < this.nodes.size()) {
            if (!this.nodes.get(i).equals(other.nodes.get(i))) {
                return this.nodes.get(i).compareTo(other.nodes.get(i));
            }
            ++i;
        }
        if (this.edgeClass != other.edgeClass) {
            return this.edgeClass.ordinal() - other.edgeClass.ordinal();
        }
        if (this.extra == null ^ other.extra == null) {
            if (this.extra == null) {
                return -1;
            }
            return 1;
        }
        if (this.extra != null && !this.extra.toString().equals(other.extra.toString())) {
            return this.extra.toString().compareTo(other.extra.toString());
        }
        if (this.supplierKey == null ^ other.supplierKey == null) {
            if (this.supplierKey == null) {
                return -1;
            }
            return 1;
        }
        if (this.supplierKey != null) {
            if (this.supplierKey instanceof Comparable) {
                return ((Comparable)this.supplierKey).compareTo(other.supplierKey);
            }
            return this.supplierKey.toString().compareTo(other.supplierKey.toString());
        }
        return 0;
    }

    public String toString() {
        String s = "PatternEdge[" + (Object)((Object)this.edgeClass) + "](";
        for (PatternNodeBase patternNodeBase : this.nodes) {
            s = String.valueOf(s) + patternNodeBase.toString() + ";";
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

