/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.util.UnionFind;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.SimpleReteBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.HyperEdgeClass;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.PatternNodeBase;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ContainmentMode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.NonInjectivityConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariableAssignment;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.ElementReference;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relationship;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.SupertypeOf;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.TypeOf;

class PatternGraph {
    protected GTPattern gtPattern;
    protected GTPatternBody body;
    protected SimpleReteBuilder<?, ?> builder;
    protected Entity graphEntity;
    protected Map<String, PatternNode> pNodeByName = new HashMap<String, PatternNode>();
    protected Collection<PatternEdge> pEdges = new LinkedList<PatternEdge>();
    protected Map<PatternNode, Collection<PatternEdge>> edgeList = new HashMap<PatternNode, Collection<PatternEdge>>();
    protected int nextVirtualNodeID = 0;
    protected UnionFind<String> variableEquivalence = new UnionFind();
    protected Map<PatternNode, Set<PatternNode>> explicitInequality = new HashMap<PatternNode, Set<PatternNode>>();
    protected Map<PatternNode, Set<PatternNode>> permittableEquality = new HashMap<PatternNode, Set<PatternNode>>();
    protected Map<PatternNode, Object> constantValues = new HashMap<PatternNode, Object>();

    public PatternGraph(GTPattern gtPattern, GTPatternBody body, SimpleReteBuilder<?, ?> builder) throws RetePatternBuildException {
        this.gtPattern = gtPattern;
        this.body = body;
        this.builder = builder;
        this.graphEntity = body.getPatternGraph();
        this.preProcessAssignments();
        this.preProcessPatternNodes();
        this.gatherInequalityAssertions();
        this.gatherContainmentConstraints();
        this.gatherRelationsAndContainments();
        this.gatherRelationships();
        this.gatherPositivePatternCalls();
        this.gatherCheckExpressions();
        this.expressTypeChecks();
        this.gatherNegativePatternCalls();
        this.touchQuantifiedVariables();
        this.connectPEdges();
        this.countTypeRestrictions();
    }

    public PatternNode getPNode(String name) {
        return this.pNodeByName.get(this.variableEquivalence.find((Object)name));
    }

    public PatternNode getPNode(Variable variable) {
        return this.getPNode(variable.getName());
    }

    public PatternNode getPNode(ModelElement element) {
        return this.getPNode(element.getName());
    }

    public Collection<PatternEdge> getEdgeList(PatternNodeBase pNode) {
        return this.edgeList.get(pNode);
    }

    public Map<PatternNode, Object> getConstantValues() {
        return this.constantValues;
    }

    public Entity getGraphEntity() {
        return this.graphEntity;
    }

    protected void preProcessAssignments() {
        for (Object o : this.body.getVariableAssignments()) {
            PatternVariableAssignment assignment = (PatternVariableAssignment)o;
            String lName = assignment.getLeftValue().getVariable().getName();
            String rName = assignment.getRightValue().getVariable().getName();
            this.variableEquivalence.unite((Object)lName, (Object)rName);
        }
    }

    protected void preProcessPatternNodes() throws RetePatternBuildException {
        for (Object o : this.gtPattern.getSymParameters()) {
            this.preProcessPatternNodeVariables((PatternVariable)o);
        }
        for (Object o : this.body.getLocalVariables()) {
            this.preProcessPatternNodeVariables((PatternVariable)o);
        }
        this.preProcessPatternNodeEntities((Collection<Entity>)this.graphEntity.getComponents());
    }

    protected void preProcessPatternNodeVariables(PatternVariable variable) {
        String name = variable.getName();
        if (this.variableEquivalence.isRoot((Object)name)) {
            PatternNode pNode = new PatternNode((Variable)variable);
            this.pNodeByName.put(name, pNode);
            this.edgeList.put(pNode, new LinkedList());
            HashSet<PatternNode> permitted = new HashSet<PatternNode>();
            permitted.add(pNode);
            this.permittableEquality.put(pNode, permitted);
            this.explicitInequality.put(pNode, new HashSet());
        }
    }

    protected void preProcessPatternNodeEntities(Collection<Entity> entities) throws RetePatternBuildException {
        for (Entity entity : entities) {
            String name = entity.getName();
            this.getPNode(name).setSource((ModelElement)entity);
            this.preProcessPatternNodeEntities((Collection<Entity>)entity.getComponents());
        }
    }

    public PatternNode newConstant(Constant constant) throws RetePatternBuildException {
        Object value = constant.getKind().getValue() == 5 ? this.builder.getContext().resolveConstant(constant.getValue()) : constant.getValue();
        return this.newConstantValue(value);
    }

    public PatternNode newConstant(ElementReference reference) throws RetePatternBuildException {
        String fqn = ((Constant)reference.getArgument()).getValue();
        return this.newConstant(fqn);
    }

    public PatternNode newConstant(String fqn) throws RetePatternBuildException {
        Object value = this.builder.getContext().resolveConstant(fqn);
        return this.newConstantValue(value);
    }

    public PatternNode substituteTerm(Term term) throws RetePatternBuildException {
        PatternNode pNode = this.newVirtualNode();
        this.pEdges.add(new PatternEdge(this, term, pNode));
        return pNode;
    }

    public void instantiationIndirect(PatternNode type, PatternNode instance) {
        PatternNode virtual = this.newVirtualNode();
        this.pEdges.add(new PatternEdge(this, type, virtual, HyperEdgeClass.GENERALIZATION_TRANSITIVE));
        this.pEdges.add(new PatternEdge(this, virtual, instance, HyperEdgeClass.INSTANTIATION_DIRECT));
    }

    PatternNode newConstantValue(Object value) {
        PatternNode pNode = this.newVirtualNode();
        this.constantValues.put(pNode, value);
        return pNode;
    }

    PatternNode newVirtualNode() {
        int newId = this.nextVirtualNodeID++;
        PatternNode pNode = new PatternNode(newId);
        this.pNodeByName.put(pNode.name, pNode);
        this.edgeList.put(pNode, new LinkedList());
        return pNode;
    }

    void touchQuantifiedVariables() {
        for (Object o : this.gtPattern.getSymParameters()) {
            this.getPNode((Variable)((PatternVariable)o)).isTouched = true;
        }
        for (PatternEdge edge : this.pEdges) {
            edge.touchQuantifiedNodes();
        }
    }

    void connectPEdges() {
        for (PatternEdge edge : this.pEdges) {
            edge.connectNodes();
        }
    }

    protected void gatherInequalityAssertions() {
        for (Object o : this.body.getNonInjectivityConstraints()) {
            NonInjectivityConstraint nic = (NonInjectivityConstraint)o;
            PatternNode left = this.getPNode(nic.getLeftValue().getVariable());
            PatternNode right = this.getPNode(nic.getRightValue().getVariable());
            this.explicitInequality.get(left).add(right);
            this.explicitInequality.get(right).add(left);
        }
    }

    protected void gatherRelationsAndContainments() {
        TreeSet<PatternNode> nodeQueue = new TreeSet<PatternNode>(this.pNodeByName.values());
        for (Object rel : this.body.getDanglingRelations()) {
            this.gatherRelation((Relation)rel, nodeQueue);
        }
        while (!nodeQueue.isEmpty()) {
            Relation rel;
            PatternNode pNode = nodeQueue.first();
            nodeQueue.remove(pNode);
            if (pNode.source == null) continue;
            for (Object o : pNode.source.getRelationsFrom()) {
                rel = (Relation)o;
                this.gatherRelation(rel, nodeQueue);
            }
            for (Object o : pNode.source.getRelationsTo()) {
                rel = (Relation)o;
                this.gatherRelation(rel, nodeQueue);
            }
            if (!(pNode.source instanceof Entity)) continue;
            Entity entity = (Entity)pNode.source;
            for (Object o : entity.getComponents()) {
                this.pEdges.add(new PatternEdge(this, pNode, this.getPNode((ModelElement)((Entity)o)), HyperEdgeClass.CONTAINMENT_DIRECT));
            }
        }
    }

    protected void gatherRelation(Relation rel, Set<PatternNode> nodeQueue) {
        PatternNode pNode = this.getPNode((ModelElement)rel);
        if (pNode.source == null) {
            pNode.setSource((ModelElement)rel);
            if (!nodeQueue.contains(pNode)) {
                nodeQueue.add(pNode);
            }
        }
    }

    protected void gatherRelationships() throws RetePatternBuildException {
        ArrayList<PatternNode> nodes = new ArrayList<PatternNode>(this.pNodeByName.values());
        LinkedHashSet<Relationship> relationships = new LinkedHashSet<Relationship>((Collection<Relationship>)this.body.getDanglingRelationships());
        for (PatternNode pNode : nodes) {
            if (pNode.source == null) continue;
            boolean typed = false;
            for (Object o : pNode.source.getSuperRelationships()) {
                Relationship rship = (Relationship)o;
                if (rship instanceof TypeOf && rship.getSupplier() != null && rship.getSupplier().getRealElement() != null && !rship.getSupplier().getRealElement().equals("")) {
                    typed = true;
                    String supplierName = rship.getSupplier().getRealElement();
                    if (pNode.source instanceof Relation) {
                        Object trgType;
                        Object srcType;
                        Object typeObject;
                        Relation relation = (Relation)pNode.source;
                        if (this.builder.getContext().edgeInterpretation() == IPatternMatcherContext.EdgeInterpretation.TERNARY) {
                            typeObject = this.builder.getContext().retrieveTernaryEdgeType(supplierName);
                            pNode.assertedTypes.add(typeObject);
                            if (typeObject == null) continue;
                            srcType = this.builder.getContext().ternaryEdgeSourceType(typeObject);
                            trgType = this.builder.getContext().ternaryEdgeTargetType(typeObject);
                            this.implyTypes(srcType, this.getPNode((String)relation.getFromStr()).impliedTypes);
                            this.implyTypes(trgType, this.getPNode((String)relation.getToStr()).impliedTypes);
                            continue;
                        }
                        try {
                            typeObject = this.builder.getContext().retrieveBinaryEdgeType(supplierName);
                        }
                        catch (RetePatternBuildException e) {
                            throw new RetePatternBuildException(e.getMessage(), e.getTemplateContext(), (Object)this.gtPattern);
                        }
                        pNode.assertedTypes.add(typeObject);
                        if (typeObject == null) continue;
                        srcType = this.builder.getContext().binaryEdgeSourceType(typeObject);
                        trgType = this.builder.getContext().binaryEdgeTargetType(typeObject);
                        this.implyTypes(srcType, this.getPNode((String)relation.getFromStr()).impliedTypes);
                        this.implyTypes(trgType, this.getPNode((String)relation.getToStr()).impliedTypes);
                        continue;
                    }
                    Object typeObject = this.builder.getContext().retrieveUnaryType(supplierName);
                    pNode.assertedTypes.add(typeObject);
                    continue;
                }
                relationships.add(rship);
            }
            if (!typed) {
                pNode.assertedTypes.add(null);
            }
            for (Object o : pNode.source.getSubRelationships()) {
                relationships.add((Relationship)o);
            }
        }
        for (Relationship rship : relationships) {
            this.gatherRelationship(rship);
        }
    }

    protected void gatherRelationship(Relationship rship) throws RetePatternBuildException {
        HyperEdgeClass edgeClass;
        String supplierName;
        PatternNode supplierNode;
        String clientName = rship.getClientStr();
        PatternNode clientNode = this.getPNode(clientName);
        if (clientNode == null) {
            clientNode = this.newConstant(clientName);
        }
        if ((supplierNode = this.getPNode(supplierName = rship.getSupplierStr())) == null) {
            supplierNode = this.newConstant(supplierName);
        }
        if (rship instanceof TypeOf) {
            edgeClass = HyperEdgeClass.INSTANTIATION_TRANSITIVE;
        } else if (rship instanceof SupertypeOf) {
            edgeClass = HyperEdgeClass.GENERALIZATION_TRANSITIVE;
        } else {
            String[] args = new String[]{rship.eClass().getName(), supplierName, clientName, this.gtPattern.getFqn()};
            String msg = "Unsupported VPM Relationship type: {1} encountered between {2} and {3} in pattern {4}";
            throw new RetePatternBuildException(msg, args, (Object)this.gtPattern);
        }
        this.pEdges.add(new PatternEdge(this, supplierNode, clientNode, edgeClass));
    }

    private void implyTypes(Object typeObj, Set<Object> impliedTypes) {
        if (typeObj != null && impliedTypes.add(typeObj)) {
            for (Object superType : this.builder.getContext().enumerateDirectSupertypes(typeObj)) {
                this.implyTypes(superType, impliedTypes);
            }
        }
    }

    protected void expressTypeChecks() {
        for (PatternNode pNode : this.pNodeByName.values()) {
            for (Object assertedType : pNode.assertedTypes) {
                if (pNode.source instanceof Relation) {
                    this.pEdges.add(new PatternEdge(this, (Relation)pNode.source, assertedType));
                    continue;
                }
                if ((assertedType != null || !pNode.impliedTypes.isEmpty()) && (assertedType == null || pNode.impliedTypes.contains(assertedType))) continue;
                this.pEdges.add(new PatternEdge(this, (Entity)pNode.source, assertedType));
            }
        }
    }

    protected void gatherContainmentConstraints() throws RetePatternBuildException {
        for (Object o : this.body.getContainmentConstraints()) {
            PatternNode parent;
            HyperEdgeClass relationshipClass;
            ContainmentConstraint cc = (ContainmentConstraint)o;
            PatternNode child = this.getPNode(cc.getVariable());
            boolean transitive = cc.getMode().equals((Object)ContainmentMode.BELOW_LITERAL);
            HyperEdgeClass hyperEdgeClass = relationshipClass = transitive ? HyperEdgeClass.CONTAINMENT_TRANSITIVE : HyperEdgeClass.CONTAINMENT_DIRECT;
            if (cc.getParent() instanceof VariableReference) {
                VariableReference parentVar = (VariableReference)cc.getParent();
                PatternNode parent2 = this.getPNode(parentVar.getVariable());
                this.pEdges.add(new PatternEdge(this, parent2, child, relationshipClass));
                continue;
            }
            if (cc.getParent() instanceof Constant) {
                parent = this.newConstant((Constant)cc.getParent());
                this.pEdges.add(new PatternEdge(this, parent, child, relationshipClass));
                continue;
            }
            if (cc.getParent() instanceof ElementReference) {
                parent = this.newConstant((ElementReference)cc.getParent());
                this.pEdges.add(new PatternEdge(this, parent, child, relationshipClass));
                continue;
            }
            parent = this.substituteTerm(cc.getParent());
            this.pEdges.add(new PatternEdge(this, parent, child, relationshipClass));
        }
    }

    protected void gatherPositivePatternCalls() throws RetePatternBuildException {
        for (Object o : this.body.getCalledPatterns()) {
            GTPatternCall call = (GTPatternCall)o;
            this.pEdges.add(new PatternEdge(this, call, false));
        }
    }

    protected void gatherNegativePatternCalls() throws RetePatternBuildException {
        for (Object o : this.body.getNegativePatterns()) {
            GTPatternCall call = (GTPatternCall)o;
            this.pEdges.add(new PatternEdge(this, call, true));
        }
    }

    protected void gatherCheckExpressions() throws RetePatternBuildException {
        for (Object o : this.body.getCheckExpressions()) {
            Term term = (Term)o;
            this.pEdges.add(new PatternEdge(this, term, null));
        }
    }

    public void countTypeRestrictions() {
        for (PatternEdge e : this.pEdges) {
            int[] nArray = e.conveysTypeInformationIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                PatternNodeBase node = e.nodes.get(index);
                ++node.lingeringTypeInfoCounter;
                for (PatternEdge f : this.edgeList.get(node)) {
                    ++f.totalLingeringTypeInfoCounter;
                }
                ++n2;
            }
        }
    }
}

