/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;

public class NativeImportAction
extends AbstractFrameworkGUIAction {
    private String iImporterID;

    public NativeImportAction(FrameworkTreeView part, String importerid) {
        this.setupInternals(part);
        this.iImporterID = importerid;
        this.setText("Native import");
        this.setToolTipText("Import a file into the modelspace using a Viatra native importer");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    public void run() {
        this.refreshSelection();
        FileDialog fop = new FileDialog(this.iFT.getSite().getShell(), 4096);
        fop.setText("Choose a file to import");
        fop.setFilterExtensions(new String[]{"*.*"});
        fop.setFilterNames(new String[]{"All files"});
        final String fn = fop.open();
        if (fn != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Native import: " + fn, 3);
                        Long c = System.currentTimeMillis();
                        monitor.worked(1);
                        NativeImportAction.this.iViatraFramework.nativeImport(fn, NativeImportAction.this.iImporterID);
                        monitor.worked(2);
                        Long c2 = System.currentTimeMillis();
                        NativeImportAction.this.iViatraFramework.getLogger().info("Native import lasted for " + new Long(c2 - c).toString() + " ms");
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            FrameworkGUIPlugin.runAsLongTransaction(runnable, "Native import: " + fn, this.iViatraFramework);
        }
    }
}

