/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.CorePackage;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Module;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Transformation;
import org.eclipse.viatra2.loaders.Loader;

public class XMITransformationLoader
implements Loader {
    public Object process(InputStream f, IFramework fw) throws VPMRuntimeException {
        throw new VPMRuntimeException("The XMI loader does not support loading from an InputStream.");
    }

    public Object processFile(String fileName, IFramework fw) throws VPMRuntimeException {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getPackageRegistry().put((Object)"http:///viatragtasmmodel/gtasm/metamodel/asm/core.ecore", (Object)CorePackage.eINSTANCE);
        Resource res = rs.getResource(URI.createFileURI((String)fileName), true);
        try {
            res.load(null);
        }
        catch (IOException iOException) {
            throw new VPMRuntimeException("XMI transformation load error");
        }
        if (res.getContents().get(0) instanceof Transformation) {
            Transformation t = (Transformation)res.getContents().get(0);
            try {
                Iterator iterator = t.getModules().iterator();
                if (iterator.hasNext()) {
                    Object _mod = iterator.next();
                    Machine m = (Machine)((Module)_mod).getMachine().get(0);
                    fw.addMachine(m.getFqn(), (Object)m);
                    return m;
                }
            }
            catch (Exception e) {
                throw new VPMRuntimeException(e.getMessage());
            }
        }
        return null;
    }
}

