/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.code;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.frameworkgui.views.code.CodeBufferView;

public class SaveOutputAction
extends Action {
    CodeBufferView cbv;

    public SaveOutputAction(CodeBufferView v) {
        this.cbv = v;
        this.setToolTipText("Save current buffer content to a file in the workspace");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.setText("Save output");
    }

    public void run() {
        String target = null;
        String targetName = null;
        CodeBufferView.DummyPage.DummyBufferPage pp = this.cbv.getCurrentInnerPage();
        if (pp == null) {
            target = this.cbv.getCurrentOuterPage().defaultBuffer.toString();
            if (target == null || target.length() < 1) {
                target = this.cbv.getCurrentOuterPage().defaultDisplay.getText();
            }
            targetName = "default";
        } else {
            target = pp.text.getText();
            targetName = pp.key.replaceFirst("core://", "");
        }
        SaveAsDialog d = new SaveAsDialog(this.cbv.getViewSite().getShell());
        d.setBlockOnOpen(true);
        d.setTitle("Save buffer output");
        d.setOriginalName(targetName);
        if (d.open() == 0) {
            try {
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(d.getResult());
                FileWriter wr = new FileWriter(new File(ifile.getLocation().toOSString()));
                try {
                    wr.write(target);
                }
                finally {
                    wr.flush();
                    wr.close();
                }
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                FrameworkManager.getInstance().getFramework(this.cbv.getCurrentOuterPage().frameworkId).getLogger().fatal(e.getMessage());
            }
            catch (CoreException e) {
                FrameworkManager.getInstance().getFramework(this.cbv.getCurrentOuterPage().frameworkId).getLogger().fatal(e.getMessage());
            }
        }
    }
}

