/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports.vtml;

import java.util.HashSet;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.imports.vtml.ASTBuilder;
import org.eclipse.viatra2.imports.vtml.ElementDefinition;
import org.eclipse.viatra2.imports.vtml.RelationDefinition;
import org.eclipse.viatra2.imports.vtml.VTMLMetaModelHelper;

public class EntityDefinition
extends ElementDefinition {
    IEntity element = null;
    String namespace;
    String type;
    String name;
    String value;
    IEntity ns;
    IModelElement typ;
    HashSet<EntityDefinition> content = new HashSet();
    public boolean isNative = false;
    EntityDefinition _type = null;
    EntityDefinition _namespace = null;
    IEntity me;
    IEntity tmp;
    String tmpName;
    IModelManager mm;

    @Override
    public IModelElement getElement() {
        if (this.element == null) {
            this.elemGen(VTMLMetaModelHelper.getInstance().getMSpace());
        }
        return this.element;
    }

    public String toString() {
        return "entity name : " + this.name + " type : " + this.type + " namespace : " + this.namespace + " value : " + this.value;
    }

    public void addContent(EntityDefinition e) {
        this.content.add(e);
    }

    public EntityDefinition(IEntity e) {
        this.element = e;
        this.name = e.getFullyQualifiedName();
        this.namespace = "";
        this.isNative = true;
    }

    public EntityDefinition(int l, String ns, String n, String t, String v) {
        this.setLine(l);
        this.namespace = ns;
        this.name = n;
        this.type = t;
        this.value = v;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getFQN() {
        return this.fqn(this.namespace, this.name);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void normalizeName(ASTBuilder ab) {
        if (this.name.indexOf(46) >= 0) {
            this.namespace = ab.parentName(this.name);
            this.name = ab.localName(this.name);
        }
    }

    @Override
    public boolean checkDefintion(ASTBuilder ab, IModelSpace m) {
        if (!this.isNative) {
            String tmp = null;
            tmp = ab.fqn(this.namespace, this.name);
            this.namespace = ab.parentName(tmp);
            this.name = ab.localName(tmp);
            this._namespace = ab.getEntityWithLookup("", this.namespace);
            this._type = ab.getEntityWithLookup(this.namespace, this.type);
            if (!(this._type != null || this.type != null && this.type.equals("entity"))) {
                ab.log.error("type " + this.type + " for entity " + this.name + " not found. Error in line " + this.getLine());
                return false;
            }
            if (ab.lookupDuplicateEntity(this) != null) {
                ab.log.error("Entity " + this.name + " in namespace " + this.namespace + " already defined. Error in line " + this.getLine());
                return false;
            }
        }
        for (EntityDefinition e : (HashSet)this.content.clone()) {
            boolean b = e.checkDefintion(ab, m);
            if (b) continue;
            return b;
        }
        for (RelationDefinition r : this.relations) {
            boolean btm = r.checkDefintion(ab, m);
            if (btm) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generateElements(ASTBuilder ab, IModelSpace m, IEntity temp) throws VPMCoreException {
        this.mm = m.getModelManager();
        this.tmp = temp;
        this.tmpName = ab.nameGenerator();
        this.me = this.value != null ? m.getModelManager().newEntity(this.tmpName, this.value, temp) : m.getModelManager().newEntity(this.tmpName, temp);
    }

    @Override
    public void resolveReferences(ASTBuilder ab) throws VPMCoreException {
    }

    @Override
    public void updateModelspace(ASTBuilder ab, IModelSpace m) throws VPMCoreException {
        this.elemGen(m);
        for (EntityDefinition e : this.content) {
            e.updateModelspace(ab, m);
        }
        for (RelationDefinition r : this.relations) {
            r.updateModelspace(ab, m);
        }
    }

    public void elemGen(IModelSpace m) {
        try {
            if (this.element == null) {
                this.element = this._namespace != null ? m.getModelManager().newEntity(this.name, (IEntity)this._namespace.getElement()) : m.getModelManager().newEntity(this.name);
                if (this.value != null) {
                    m.getModelManager().setValue(this.element, this.value);
                }
                if (this._type != null) {
                    m.getModelManager().newInstanceOf(this._type.getElement(), (IModelElement)this.element);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashSet<EntityDefinition> getContent() {
        return this.content;
    }

    @Override
    public void printDebug(int i) {
        System.out.println(String.valueOf("-------------------------------------------------------------------------------------------------------------------------------------------------".substring(0, i)) + this.getFQN());
        for (EntityDefinition entityDefinition : this.content) {
            entityDefinition.printDebug(i + 3);
        }
        for (RelationDefinition relationDefinition : this.relations) {
            relationDefinition.printDebug(i + 3);
        }
    }
}

