/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports.vtml;

import java.io.InputStream;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.imports.vtml.ASTBuilder;
import org.eclipse.viatra2.imports.vtml.VTMLMetaModelHelper;
import org.eclipse.viatra2.imports.vtml.VTMLParser;
import org.eclipse.viatra2.logger.Logger;

public class VTMLLoad {
    Logger log;
    IModelSpace mod;
    ASTBuilder ab;

    public void process(InputStream f, IModelSpace m, IFramework fw, Logger l) throws VPMRuntimeException {
        try {
            this.init(m, l);
            VTMLParser p = new VTMLParser();
            try {
                p.processFile(f, this.ab, this.log);
            }
            catch (Exception exception) {
                VTMLMetaModelHelper.deleteInstance();
                return;
            }
            if (this.ab.checkDefinition()) {
                this.log.info("Reference check ok.");
                this.ab.generateElements();
            }
            VTMLMetaModelHelper.deleteInstance();
        }
        catch (Exception e) {
            VTMLMetaModelHelper.deleteInstance();
            this.log.error("Internal exception during parse.");
            e.printStackTrace();
        }
    }

    public void init(IModelSpace m, Logger l) throws VPMRuntimeException {
        this.log = l;
        this.mod = m;
        this.ab = new ASTBuilder();
        this.ab.init(this.log, m);
        this.log.debug("VTML import initialized");
    }

    public void deInit() {
        this.log = null;
        this.mod = null;
        this.ab = null;
    }

    public String getName() {
        return "Viatra Tectual Command Language Parser";
    }

    public void processFile(String f, IModelSpace m, IFramework fw, Logger l) throws VPMRuntimeException {
        try {
            this.init(m, l);
            VTMLParser p = new VTMLParser();
            try {
                p.processFile(f, this.ab, this.log);
            }
            catch (Exception exception) {
                VTMLMetaModelHelper.deleteInstance();
                return;
            }
            if (this.ab.checkDefinition()) {
                this.log.info("Reference check ok.");
                this.ab.generateElements();
            }
            VTMLMetaModelHelper.deleteInstance();
        }
        catch (Exception e) {
            VTMLMetaModelHelper.deleteInstance();
            this.log.error("Internal exception during parse.");
            e.printStackTrace();
        }
    }
}

