/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.typechecker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;

public class TypeResolver {
    public String leastUpperBound(IModelManager modelManager, String typeStr1, String typeStr2) {
        if (this.isSupertype(modelManager, typeStr1, typeStr2)) {
            return typeStr1;
        }
        if (this.isSupertype(modelManager, typeStr2, typeStr1)) {
            return typeStr2;
        }
        IModelElement me1 = modelManager.getElementByName(typeStr1);
        IModelElement me2 = modelManager.getElementByName(typeStr2);
        if (me1 == null || me2 == null) {
            return "TOP";
        }
        if (me1.isSubtypeOf(me2)) {
            return me1.getFullyQualifiedName();
        }
        if (me2.isSubtypeOf(me1)) {
            return me2.getFullyQualifiedName();
        }
        HashSet<IModelElement> commonSupertypes = new HashSet<IModelElement>();
        this.traverseSupertypeHierarchy(me1, me2, commonSupertypes);
        if (!commonSupertypes.isEmpty()) {
            if (commonSupertypes.size() == 1) {
                return ((IModelElement)commonSupertypes.iterator().next()).getFullyQualifiedName();
            }
            return "BOTTOM";
        }
        if (me1.isEntity() && me2.isEntity()) {
            return "ENTITY";
        }
        if (me1.isRelation() && me2.isRelation()) {
            return "RELATION";
        }
        return "MODELELEMENT";
    }

    protected void traverseSupertypeHierarchy(IModelElement current, IModelElement other, Set<IModelElement> resolutionSet) {
        ArrayList<IModelElement> toTraverseList = new ArrayList<IModelElement>();
        for (IModelElement element : current.getSupertypes()) {
            if (other.isSupertypeOf(element)) {
                boolean subtypeFound = false;
                Iterator<IModelElement> iter = resolutionSet.iterator();
                while (!subtypeFound && iter.hasNext()) {
                    IModelElement existing = iter.next();
                    if (!element.isSubtypeOf(existing)) continue;
                    subtypeFound = true;
                }
                if (subtypeFound) continue;
                resolutionSet.add(element);
                continue;
            }
            toTraverseList.add(element);
        }
        for (IModelElement toTraverse : toTraverseList) {
            this.traverseSupertypeHierarchy(toTraverse, other, resolutionSet);
        }
    }

    protected String checkOrPrimitiveTypes(String typeStr1, String typeStr2) {
        if (typeStr1.equals("TOP") || typeStr2.equals("TOP")) {
            return "TOP";
        }
        if (typeStr1.equals("BOTTOM")) {
            return typeStr2;
        }
        if (typeStr2.equals("BOTTOM")) {
            return typeStr1;
        }
        if (typeStr1.equals("MODELELEMENT") && (typeStr2.equals("ENTITY") || typeStr2.equals("RELATION"))) {
            return "MODELELEMENT";
        }
        if (typeStr2.equals("MODELELEMENT") && (typeStr1.equals("ENTITY") || typeStr1.equals("RELATION"))) {
            return "MODELELEMENT";
        }
        if (typeStr1.equals("ENTITY") && typeStr2.equals("ENTITY")) {
            return "ENTITY";
        }
        if (typeStr1.equals("RELATION") && typeStr2.equals("RELATION")) {
            return "RELATION";
        }
        if (typeStr1.equals("RELATION") && typeStr2.equals("ENTITY") || typeStr1.equals("ENTITY") && typeStr2.equals("RELATION")) {
            return "MODELELEMENT";
        }
        return null;
    }

    protected String checkAndPrimitiveTypes(String typeStr1, String typeStr2) {
        if (typeStr1.equals("TOP")) {
            return typeStr2;
        }
        if (typeStr2.equals("TOP")) {
            return typeStr1;
        }
        if (typeStr1.equals("BOTTOM") || typeStr2.equals("BOTTOM")) {
            return "BOTTOM";
        }
        if (typeStr2.equals("MODELELEMENT") && typeStr1.equals("MODELELEMENT")) {
            return "MODELELEMENT";
        }
        if (typeStr2.equals("MODELELEMENT") && typeStr1.equals("ENTITY") || typeStr1.equals("MODELELEMENT") && typeStr2.equals("ENTITY")) {
            return "ENTITY";
        }
        if (typeStr2.equals("MODELELEMENT") && typeStr1.equals("RELATION") || typeStr1.equals("MODELELEMENT") && typeStr2.equals("RELATION")) {
            return "RELATION";
        }
        if (typeStr1.equals("ENTITY") && typeStr2.equals("RELATION") || typeStr2.equals("ENTITY") && typeStr1.equals("RELATION")) {
            return "BOTTOM";
        }
        return null;
    }

    public String greatestLowerBound(IModelManager modelManager, String typeStr1, String typeStr2) {
        if (this.isSupertype(modelManager, typeStr1, typeStr2)) {
            return typeStr2;
        }
        if (this.isSupertype(modelManager, typeStr2, typeStr1)) {
            return typeStr1;
        }
        IModelElement me1 = modelManager.getElementByName(typeStr1);
        IModelElement me2 = modelManager.getElementByName(typeStr2);
        if (me1 == null || me2 == null) {
            return "BOTTOM";
        }
        if (me1.isSubtypeOf(me2)) {
            return me2.getFullyQualifiedName();
        }
        if (me2.isSubtypeOf(me1)) {
            return me1.getFullyQualifiedName();
        }
        HashSet<IModelElement> commonSubtypes = new HashSet<IModelElement>();
        this.traverseSubtypeHierarchy(me1, me2, commonSubtypes);
        if (!commonSubtypes.isEmpty()) {
            if (commonSubtypes.size() == 1) {
                return ((IModelElement)commonSubtypes.iterator().next()).getFullyQualifiedName();
            }
            return "BOTTOM";
        }
        if (me1.isEntity() && me2.isEntity()) {
            return "ENTITY";
        }
        if (me1.isRelation() && me2.isRelation()) {
            return "RELATION";
        }
        return "BOTTOM";
    }

    protected void traverseSubtypeHierarchy(IModelElement current, IModelElement other, Set<IModelElement> resolutionSet) {
        ArrayList<IModelElement> toTraverseList = new ArrayList<IModelElement>();
        for (IModelElement element : current.getSubtypes()) {
            if (other.isSubtypeOf(element)) {
                boolean supertypeFound = false;
                Iterator<IModelElement> iter = resolutionSet.iterator();
                while (!supertypeFound && iter.hasNext()) {
                    IModelElement existing = iter.next();
                    if (!element.isSupertypeOf(existing)) continue;
                    supertypeFound = true;
                }
                if (supertypeFound) continue;
                resolutionSet.add(current);
                continue;
            }
            toTraverseList.add(element);
        }
        for (IModelElement toTraverse : toTraverseList) {
            this.traverseSubtypeHierarchy(toTraverse, other, resolutionSet);
        }
    }

    public boolean isSupertype(IModelManager modelManager, String supertypeStr, String subtypeStr) {
        if (supertypeStr.equals("TOP") || subtypeStr.equals("TOP")) {
            return true;
        }
        if (supertypeStr.equals("BOTTOM")) {
            return false;
        }
        if (subtypeStr.equals("BOTTOM")) {
            return true;
        }
        if (supertypeStr.equals("MODELELEMENT")) {
            if (subtypeStr.equals("MODELELEMENT") || subtypeStr.equals("ENTITY") || subtypeStr.equals("RELATION")) {
                return true;
            }
            IModelElement subElem = modelManager.getElementByName(subtypeStr);
            return subElem != null;
        }
        if (supertypeStr.equals("ENTITY")) {
            if (subtypeStr.equals("ENTITY")) {
                return true;
            }
            if (subtypeStr.equals("MODELELEMENT") || subtypeStr.equals("RELATION")) {
                return false;
            }
            IModelElement subElem = modelManager.getElementByName(subtypeStr);
            return subElem != null && subElem.isEntity();
        }
        if (supertypeStr.equals("RELATION")) {
            if (subtypeStr.equals("RELATION")) {
                return true;
            }
            if (subtypeStr.equals("MODELELEMENT") || subtypeStr.equals("ENTITY")) {
                return false;
            }
            IModelElement subElem = modelManager.getElementByName(subtypeStr);
            return subElem != null && subElem.isRelation();
        }
        IModelElement superElem = modelManager.getElementByName(supertypeStr);
        IModelElement subElem = modelManager.getElementByName(subtypeStr);
        return superElem != null && subElem != null && (subElem == superElem || superElem.isSupertypeOf(subElem));
    }

    public String lookupType(IModelElement modelElement) {
        Collection types = modelElement.getTypes();
        int size = types.size();
        switch (size) {
            case 0: {
                if (modelElement.isEntity()) {
                    return "ENTITY";
                }
                if (modelElement.isRelation()) {
                    return "RELATION";
                }
                return "MODELELEMENT";
            }
            case 1: {
                return ((IModelElement)types.iterator().next()).getFullyQualifiedName();
            }
        }
        if (modelElement.isEntity()) {
            return "ENTITY";
        }
        if (modelElement.isRelation()) {
            return "RELATION";
        }
        return "MODELELEMENT";
    }

    public ValueKind getValueKind(String typeStr) {
        if (typeStr.equals("datatypes.String")) {
            return ValueKind.STRING_LITERAL;
        }
        if (typeStr.equals("datatypes.Boolean")) {
            return ValueKind.BOOLEAN_LITERAL;
        }
        if (typeStr.equals("datatypes.Integer")) {
            return ValueKind.INTEGER_LITERAL;
        }
        if (typeStr.equals("datatypes.Double")) {
            return ValueKind.DOUBLE_LITERAL;
        }
        if (typeStr.equals("datatypes.Multiplicity")) {
            return ValueKind.MULTIPLICITY_LITERAL;
        }
        if (typeStr.equals("TOP")) {
            return ValueKind.UNDEF_LITERAL;
        }
        if (typeStr.equals("BOTTOM")) {
            return ValueKind.ERROR_LITERAL;
        }
        return ValueKind.MODELELEMENT_LITERAL;
    }
}

