/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.virgo.ide.bundlerepository.domain.OsgiVersion;
import org.eclipse.virgo.ide.bundlerepository.domain.PackageExport;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.ui.editors.text.AbstractPdeManifestContentAssistProcessor;
import org.eclipse.virgo.ide.ui.editors.text.BundleTypeCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestContentAssistProcessor
extends AbstractPdeManifestContentAssistProcessor {
    private IJavaProject fJP;

    static {
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList(fHeader));
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.virgo.ide.ui.editors.text.headers");
        Enumeration<String> values = bundle.getKeys();
        while (values.hasMoreElements()) {
            headers.add(values.nextElement());
        }
        Collections.sort(headers);
        fHeader = headers.toArray(new String[headers.size()]);
    }

    public BundleManifestContentAssistProcessor(PDESourcePage sourcePage) {
        super(sourcePage);
    }

    @Override
    protected ICompletionProposal[] computeHeader(String currentValue, int startOffset, int offset) {
        ArrayList<BundleTypeCompletionProposal> completions = new ArrayList<BundleTypeCompletionProposal>();
        IBaseModel model = this.fSourcePage.getInputContext().getModel();
        int cfr_ignored_0 = fHeader.length;
        if (!(model instanceof IBundleModel) || !((IBundleModel)model).isFragmentModel()) {
            // empty if block
        }
        String[] stringArray = fHeader;
        int n = fHeader.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.regionMatches(true, 0, currentValue, 0, currentValue.length()) && this.fHeaders.get(element) == null) {
                BundleTypeCompletionProposal proposal = new BundleTypeCompletionProposal(String.valueOf(element) + ": ", this.getImage(0), element, startOffset, currentValue.length());
                proposal.setAdditionalProposalInfo(this.getJavaDoc(element));
                completions.add(proposal);
            }
            ++n2;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    @Override
    protected final boolean shouldStoreSet(String header) {
        if (header.equalsIgnoreCase("Import-Bundle") || header.equalsIgnoreCase("Import-Library") || header.equalsIgnoreCase("Export-Template") || header.equalsIgnoreCase("Import-Template") || header.equalsIgnoreCase("Excluded-Imports") || header.equalsIgnoreCase("Excluded-Exports") || header.equalsIgnoreCase("Unversioned-Imports")) {
            return true;
        }
        return super.shouldStoreSet(header);
    }

    @Override
    protected ICompletionProposal[] computeValue(IDocument doc, int startOffset, int offset) throws BadLocationException {
        int index;
        String value = doc.get(startOffset, offset - startOffset);
        int lineNum = doc.getLineOfOffset(startOffset) - 1;
        while ((index = value.indexOf(58)) == -1 || value.length() - 1 != index && value.charAt(index + 1) == '=') {
            int startLine = doc.getLineOffset(lineNum);
            value = doc.get(startLine, offset - startLine);
            --lineNum;
        }
        int length = value.length();
        if (value.regionMatches(true, 0, "Import-Bundle", 0, Math.min(length, "Import-Bundle".length()))) {
            return this.handleImportBundleCompletion(value.substring("Import-Bundle".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Import-Library", 0, Math.min(length, "Import-Library".length()))) {
            return this.handleImportLibraryCompletion(value.substring("Import-Library".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Import-Template", 0, Math.min(length, "Import-Template".length()))) {
            return this.handleImportPackageCompletion(value.substring("Import-Template".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Export-Template", 0, Math.min(length, "Export-Template".length()))) {
            return this.handleExportPackageCompletion(value.substring("Export-Template".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Excluded-Imports", 0, Math.min(length, "Excluded-Imports".length()))) {
            return this.handleImportPackageCompletion(value.substring("Excluded-Imports".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Excluded-Exports", 0, Math.min(length, "Excluded-Exports".length()))) {
            return this.handleExportPackageCompletion(value.substring("Excluded-Exports".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Unversioned-Imports", 0, Math.min(length, "Unversioned-Imports".length()))) {
            return this.handleImportPackageCompletion(value.substring("Unversioned-Imports".length() + 1), offset);
        }
        return super.computeValue(doc, startOffset, offset);
    }

    @Override
    protected ICompletionProposal[] handleImportPackageCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet set = (HashSet)this.fHeaders.get("Import-Package");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            value = this.removeLeadingSpaces(value);
            int length = value.length();
            set.remove(value);
            ArrayList<BundleTypeCompletionProposal> completions = new ArrayList<BundleTypeCompletionProposal>();
            Set packages = RepositoryUtils.getImportPackageProposals((IProject)this.getProject(), (String)value);
            for (PackageExport proposal : packages) {
                if (set.contains(proposal.getName())) continue;
                completions.add(new BundleTypeCompletionProposal(proposal.getName(), this.getImage(1), proposal.getName(), offset - length, length));
                set.add(proposal.getName());
            }
            ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
            this.sortCompletions(proposals);
            return proposals;
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            Object[] validAtts = new String[]{"version", "resolution"};
            Object[] validTypes = new Integer[]{new Integer(5), new Integer(4)};
            return this.handleAttrsAndDirectives(value, this.initializeNewList(validAtts), this.initializeNewList(validTypes), offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("resolution".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"mandatory", "optional"}, new int[]{6, 6}, offset, "RESOLUTION_");
        }
        if ("version".regionMatches(true, 0, attributeValue, 0, "version".length())) {
            String pluginId = this.removeLeadingSpaces(currentValue.substring(comma == -1 ? 0 : comma + 1, semicolon));
            return this.getPackageVersionCompletions(pluginId, this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    @Override
    protected ICompletionProposal[] handleFragmentHostCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet set = (HashSet)this.fHeaders.get("Require-Bundle");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            value = this.removeLeadingSpaces(value);
            int length = value.length();
            set.remove(value);
            ArrayList<BundleTypeCompletionProposal> completions = new ArrayList<BundleTypeCompletionProposal>();
            Set bundles = RepositoryUtils.getImportBundleProposals((IProject)this.getProject(), (String)value);
            for (IArtefact proposal : bundles) {
                if (set.contains(proposal.getSymbolicName())) continue;
                completions.add(new BundleTypeCompletionProposal(proposal.getSymbolicName(), this.getImage(2), proposal.getSymbolicName(), offset - length, length));
                set.add(proposal.getSymbolicName());
            }
            ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
            this.sortCompletions(proposals);
            return proposals;
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            return this.matchValueCompletion(this.removeLeadingSpaces(currentValue.substring(semicolon + 1)), new String[]{"bundle-version"}, new int[]{5}, offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("bundle-version".regionMatches(true, 0, attributeValue, 0, "bundle-version".length())) {
            String pluginId = this.removeLeadingSpaces(currentValue.substring(comma == -1 ? 0 : comma + 1, semicolon));
            return this.getSpringBundleVersionCompletions(pluginId, this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] handleImportLibraryCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet set = (HashSet)this.fHeaders.get("Import-Library");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            value = this.removeLeadingSpaces(value);
            int length = value.length();
            set.remove(value);
            ArrayList<BundleTypeCompletionProposal> completions = new ArrayList<BundleTypeCompletionProposal>();
            Set libraries = RepositoryUtils.getImportLibraryProposals((IProject)this.getProject(), (String)value);
            for (IArtefact proposal : libraries) {
                if (set.contains(proposal.getSymbolicName())) continue;
                completions.add(new BundleTypeCompletionProposal(proposal.getSymbolicName(), this.getImage(8), proposal.getSymbolicName(), offset - length, length));
                set.add(proposal.getSymbolicName());
            }
            ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
            this.sortCompletions(proposals);
            return proposals;
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            Object[] validAtts = new String[]{"version", "resolution", "promotes-exports"};
            Object[] validTypes = new Integer[]{new Integer(5), new Integer(4), new Integer(4)};
            return this.handleAttrsAndDirectives(value, this.initializeNewList(validAtts), this.initializeNewList(validTypes), offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("resolution".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"mandatory", "optional"}, new int[]{6, 6}, offset, "RESOLUTION_");
        }
        if ("promotes-exports".regionMatches(true, 0, attributeValue, 0, "promotes-exports".length())) {
            return this.handleTrueFalseValue(currentValue.substring(equals + 1), offset);
        }
        if ("version".regionMatches(true, 0, attributeValue, 0, "version".length())) {
            String pluginId = this.removeLeadingSpaces(currentValue.substring(comma == -1 ? 0 : comma + 1, semicolon));
            return this.getLibraryVersionCompletions(pluginId, this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] handleImportBundleCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet set = (HashSet)this.fHeaders.get("Import-Bundle");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            value = this.removeLeadingSpaces(value);
            int length = value.length();
            set.remove(value);
            ArrayList<BundleTypeCompletionProposal> completions = new ArrayList<BundleTypeCompletionProposal>();
            Set bundles = RepositoryUtils.getImportBundleProposals((IProject)this.getProject(), (String)value);
            for (IArtefact proposal : bundles) {
                if (set.contains(proposal.getSymbolicName())) continue;
                completions.add(new BundleTypeCompletionProposal(proposal.getSymbolicName(), this.getImage(2), proposal.getSymbolicName(), offset - length, length));
                set.add(proposal.getSymbolicName());
            }
            ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
            this.sortCompletions(proposals);
            return proposals;
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            Object[] validAtts = new String[]{"version", "resolution"};
            Object[] validTypes = new Integer[]{new Integer(5), new Integer(4)};
            return this.handleAttrsAndDirectives(value, this.initializeNewList(validAtts), this.initializeNewList(validTypes), offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("resolution".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"mandatory", "optional"}, new int[]{6, 6}, offset, "RESOLUTION_");
        }
        if ("version".regionMatches(true, 0, attributeValue, 0, "version".length())) {
            String pluginId = this.removeLeadingSpaces(currentValue.substring(comma == -1 ? 0 : comma + 1, semicolon));
            return this.getSpringBundleVersionCompletions(pluginId, this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    @Override
    protected ICompletionProposal[] handleRequireBundleCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet set = (HashSet)this.fHeaders.get("Require-Bundle");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            value = this.removeLeadingSpaces(value);
            int length = value.length();
            set.remove(value);
            ArrayList<BundleTypeCompletionProposal> completions = new ArrayList<BundleTypeCompletionProposal>();
            Set bundles = RepositoryUtils.getImportBundleProposals((IProject)this.getProject(), (String)value);
            for (IArtefact proposal : bundles) {
                if (set.contains(proposal.getSymbolicName())) continue;
                completions.add(new BundleTypeCompletionProposal(proposal.getSymbolicName(), this.getImage(2), proposal.getSymbolicName(), offset - length, length));
                set.add(proposal.getSymbolicName());
            }
            ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
            this.sortCompletions(proposals);
            return proposals;
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            Object[] validAttrs = new String[]{"bundle-version", "resolution", "visibility"};
            Object[] validTypes = new Integer[]{new Integer(5), new Integer(4), new Integer(4)};
            return this.handleAttrsAndDirectives(value, this.initializeNewList(validAttrs), this.initializeNewList(validTypes), offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("visibility".regionMatches(true, 0, attributeValue, 0, "visibility".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"private", "reexport"}, new int[]{6, 6}, offset, "VISIBILITY_");
        }
        if ("resolution".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"mandatory", "optional"}, new int[]{6, 6}, offset, "RESOLUTION_");
        }
        if ("bundle-version".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            String pluginId = this.removeLeadingSpaces(currentValue.substring(comma == -1 ? 0 : comma + 1, semicolon));
            return this.getSpringBundleVersionCompletions(pluginId, this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    private IProject getProject() {
        if (this.fJP == null) {
            IProject project = ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
            this.fJP = JavaCore.create((IProject)project);
        }
        return this.fJP.getProject();
    }

    private ICompletionProposal[] getSpringBundleVersionCompletions(String bundleId, String existingValue, int offset) {
        bundleId = this.getSymbolicName(bundleId);
        Set bundles = RepositoryUtils.getImportBundleProposals((IProject)this.getProject(), (String)bundleId);
        if (bundles.size() > 0) {
            ArrayList<BundleTypeCompletionProposal> proposals = new ArrayList<BundleTypeCompletionProposal>(bundles.size());
            for (IArtefact element : bundles) {
                if (!element.getSymbolicName().equalsIgnoreCase(bundleId)) continue;
                List<String> proposalValues = this.getVersionProposals(element.getVersion());
                for (String proposalValue : proposalValues) {
                    if (!proposalValue.regionMatches(0, existingValue, 0, existingValue.length())) continue;
                    proposals.add(new BundleTypeCompletionProposal(proposalValue.substring(existingValue.length()), this.getImage(6), proposalValue, offset, 0));
                }
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        if (existingValue.length() == 0) {
            return new ICompletionProposal[]{new BundleTypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] getLibraryVersionCompletions(String libraryId, String existingValue, int offset) {
        libraryId = this.getSymbolicName(libraryId);
        Set libraries = RepositoryUtils.getImportLibraryProposals((IProject)this.getProject(), (String)libraryId);
        if (libraries.size() > 0) {
            ArrayList<BundleTypeCompletionProposal> proposals = new ArrayList<BundleTypeCompletionProposal>(libraries.size());
            for (IArtefact element : libraries) {
                if (!element.getSymbolicName().equalsIgnoreCase(libraryId)) continue;
                List<String> proposalValues = this.getVersionProposals(element.getVersion());
                for (String proposalValue : proposalValues) {
                    if (!proposalValue.regionMatches(0, existingValue, 0, existingValue.length())) continue;
                    proposals.add(new BundleTypeCompletionProposal(proposalValue.substring(existingValue.length()), this.getImage(6), proposalValue, offset, 0));
                }
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        if (existingValue.length() == 0) {
            return new ICompletionProposal[]{new BundleTypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] getPackageVersionCompletions(String packageId, String existingValue, int offset) {
        HashSet<String> proposedVersions = new HashSet<String>();
        boolean wildcard = packageId.endsWith(".*");
        packageId = this.getSymbolicName(packageId);
        Set packages = RepositoryUtils.getImportPackageProposals((IProject)this.getProject(), (String)packageId);
        if (packages.size() > 0) {
            ArrayList<BundleTypeCompletionProposal> proposals = new ArrayList<BundleTypeCompletionProposal>(packages.size());
            for (PackageExport element : packages) {
                if (!wildcard && !element.getName().equalsIgnoreCase(packageId)) continue;
                List<String> proposalValues = this.getVersionProposals(element.getVersion());
                for (String proposalValue : proposalValues) {
                    if (proposedVersions.contains(proposalValue) || !proposalValue.regionMatches(0, existingValue, 0, existingValue.length())) continue;
                    proposedVersions.add(proposalValue);
                    proposals.add(new BundleTypeCompletionProposal(proposalValue.substring(existingValue.length()), this.getImage(6), proposalValue, offset, 0));
                }
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        if (existingValue.length() == 0) {
            return new ICompletionProposal[]{new BundleTypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
        }
        return new ICompletionProposal[0];
    }

    private List<String> getVersionProposals(OsgiVersion version) {
        LinkedHashSet<String> versionStrings = new LinkedHashSet<String>();
        versionStrings.add(version.toString());
        ArrayList<String> versions = new ArrayList<String>();
        for (String ver : RepositoryUtils.getVersionProposals(versionStrings)) {
            versions.add("\"" + ver + "\"");
        }
        return versions;
    }

    private String getSymbolicName(String string) {
        int ix;
        if (string.endsWith(".*")) {
            string = string.substring(0, string.length() - 2);
        }
        if ((ix = string.indexOf(59)) > 0) {
            return string.substring(0, ix);
        }
        return string;
    }

    @Override
    public Image getImage(int type) {
        if (type >= 0 && type < 9) {
            if (this.fImages[type] == null) {
                switch (type) {
                    case 8: {
                        this.fImages[type] = PDEPluginImages.DESC_JAR_LIB_OBJ.createImage();
                        return this.fImages[type];
                    }
                    case 2: {
                        this.fImages[type] = PDEPluginImages.DESC_BUNDLE_OBJ.createImage();
                        return this.fImages[type];
                    }
                }
            } else {
                return this.fImages[type];
            }
        }
        return super.getImage(type);
    }
}

