/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.eclipse.wizards;

import java.util.StringTokenizer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.virgo.ide.eclipse.wizards.PdeMessageStrings;

public abstract class ProjectContentPage
extends WizardPage {
    private static final int PROPERTIES_GROUP = 1;
    private boolean fInitialized = false;
    private Text fIdText;
    private Text fVersionText;
    private Text fNameText;
    private Text fProviderText;
    private final AbstractFieldData fData;
    private final IProjectProvider fProjectProvider;
    private int fChangedGroups = 0;
    private final ModifyListener propertiesListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ProjectContentPage.this.fInitialized) {
                ProjectContentPage projectContentPage = ProjectContentPage.this;
                projectContentPage.fChangedGroups = projectContentPage.fChangedGroups | 1;
            }
            ProjectContentPage.this.validatePage();
        }
    };

    protected ProjectContentPage(String pageName, IProjectProvider provider, AbstractFieldData data) {
        super(pageName);
        this.fProjectProvider = provider;
        this.fData = data;
        this.setTitle(this.getContentPageTitle());
        this.setDescription(this.getContentPageDescription());
    }

    private String computeId() {
        return IdUtil.getValidId((String)this.fProjectProvider.getProjectName());
    }

    protected void createPluginPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(3, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(this.getContentPageGroupLabel());
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(this.getContentPageIdLabel());
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(this.getContentPageNameLabel());
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(this.getContentPageVersionLabel());
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(this.getContentPageProviderLabel());
        this.fProviderText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
    }

    private Text createText(Composite parent, ModifyListener listener, int horizSpan) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.horizontalSpan = horizSpan;
        text.setLayoutData((Object)data);
        text.addModifyListener(listener);
        return text;
    }

    protected abstract String getContentPageDescription();

    protected abstract String getContentPageGroupLabel();

    protected abstract String getContentPageIdLabel();

    protected abstract String getContentPageNameLabel();

    protected abstract String getContentPagePluginLabel();

    protected abstract String getContentPageProviderLabel();

    protected abstract String getContentPageTitle();

    protected abstract String getContentPageVersionLabel();

    private String getValidName(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            String name = String.valueOf(Character.toUpperCase(token.charAt(0))) + (token.length() > 1 ? token.substring(1) : "");
            return name;
        }
        return "";
    }

    private boolean isVersionValid(String version) {
        return VersionUtil.validateVersion((String)version).getSeverity() == 0;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String id = this.computeId();
            if ((this.fChangedGroups & 1) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.fIdText.setText(id);
                this.fVersionText.setText("1.0.0");
                this.fNameText.setText(this.getValidName(id));
                this.fProviderText.setText(IdUtil.getValidProvider((String)id));
                this.fChangedGroups = oldfChanged;
            }
            if (this.fInitialized) {
                this.validatePage();
            } else {
                this.fInitialized = true;
            }
        }
        super.setVisible(visible);
    }

    protected void updateData() {
        this.fData.setId(this.fIdText.getText().trim());
        this.fData.setVersion(this.fVersionText.getText().trim());
        this.fData.setName(this.fNameText.getText().trim());
        this.fData.setProvider(this.fProviderText.getText().trim());
    }

    private String validateId() {
        String id = this.fIdText.getText().trim();
        if (id.length() == 0) {
            return PdeMessageStrings.ContentPage_noid;
        }
        if (!IdUtil.isValidCompositeID3_0((String)id)) {
            return PdeMessageStrings.ContentPage_invalidId;
        }
        return null;
    }

    private String validateName() {
        if (this.fNameText.getText().trim().length() == 0) {
            return PdeMessageStrings.ContentPage_noname;
        }
        return null;
    }

    protected void validatePage() {
        String errorMessage = this.validateProperties();
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private String validateProperties() {
        if (!this.fInitialized) {
            if (!this.fIdText.getText().trim().equals(this.fProjectProvider.getProjectName())) {
                this.setMessage(PdeMessageStrings.ContentPage_illegalCharactersInID, 1);
            } else {
                this.setMessage(null);
            }
            return null;
        }
        this.setMessage(null);
        String errorMessage = null;
        errorMessage = this.validateId();
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = this.validateVersion(this.fVersionText);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = this.validateName();
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    private String validateVersion(Text text) {
        if (text.getText().trim().length() == 0) {
            return PDELabelUtility.qualifyMessage((String)PDELabelUtility.getFieldLabel((Control)text), (String)PdeMessageStrings.ControlValidationUtility_errorMsgValueMustBeSpecified);
        }
        if (!this.isVersionValid(text.getText().trim())) {
            return PDELabelUtility.qualifyMessage((String)PDELabelUtility.getFieldLabel((Control)text), (String)PdeMessageStrings.BundleErrorReporter_InvalidFormatInBundleVersion);
        }
        return null;
    }
}

