/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.virgo.ide.runtime.internal.ui.RuntimeListener;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProjectManager;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.BundleContext;

public class ServerUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.virgo.ide.runtime.ui";
    private static final String RESOURCE_NAME = "org.eclipse.virgo.ide.runtime.internal.ui.messages";
    public static final String REPOSITORY_PAGE_ID = "org.eclipse.virgo.ide.server.ui.configuration.editor.repository";
    public static final String PREF_DOWNLOAD_MESSAGE_KEY = "org.eclipse.virgo.ide.runtime.ui..download.message";
    private static ServerUiPlugin plugin;
    private ResourceBundle resourceBundle;
    public static final String WST_SERVER_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    public static final String WST_EDITOR_ID = "org.eclipse.wst.server.ui.internal.editor.ServerEditor";
    public static final String ARTEFACTS_BROWSER_VIEW_ID = "org.eclipse.virgo.ide.runtime.ui.ArtefactsBrowserView";
    public static final String ARTEFACTS_DETAIL_VIEW_ID = "org.eclipse.virgo.ide.runtime.ui.ArtefactsDetailView";
    public static final String RUNTIME_OUTLINE_VIEW_ID = "org.eclipse.virgo.ide.runtime.ui.OutlineView";
    public static final String PROPERTIES_VIEW_ID = "org.eclipse.virgo.ide.runtime.ui.PropertiesView";
    public static final String PROPERTIES_CONTENT_ID = "org.eclipse.virgo.ide.runtime.ui.properties";
    public static final String FLATTENED_PROPERTIES_CONTENT_ID = "org.eclipse.virgo.ide.runtime.ui.flattenedProperties";
    public static final String LOG_VIEW_ID = "org.eclipse.virgo.ide.runtime.ui.LogView";
    public static final String LOG_CONTENT_ID = "org.eclipse.virgo.ide.runtime.ui.logs";
    public static final String RUNTIME_ARTEFACTS_CONTENT_ID = "org.eclipse.virgo.ide.runtime.ui.runtimeArtefacts";
    public static final String RUNTIME_FLATTENED_ARTEFACTS_CONTENT_ID = "org.eclipse.virgo.ide.runtime.ui.flattenedRuntimeArtefacts";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        plugin.getPreferenceStore().setDefault(PREF_DOWNLOAD_MESSAGE_KEY, false);
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)RuntimeListener.getDefault());
        ServerProjectManager.getInstance().updateProjects();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)RuntimeListener.getDefault());
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ServerUiImages.initializeImageRegistry(reg);
    }

    public static ServerUiPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        ServerUiPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = ServerUiPlugin.createErrorStatus(message, exception);
        ServerUiPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        ServerUiPlugin.getDefault().getLog().log(ServerUiPlugin.createErrorStatus("Internal Error", exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = ServerUiPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                ServerUiPlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public final ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

