/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

abstract class AbstractConvertAction
implements IObjectActionDelegate {
    protected List<?> projects;
    protected IWorkbenchPart part;

    protected abstract String getNature();

    public void run(IAction arg0) {
        boolean result = this.showConfirmationDialog();
        if (!result) {
            return;
        }
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.part.getSite().getShell());
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
                    AbstractConvertAction.this.migrate(arg0);
                }
            });
        }
        catch (Exception e) {
            Status s = new Status(4, "org.eclipse.virgo.ide.ui", e.getMessage());
            StatusManager.getManager().handle((IStatus)s, 2);
        }
    }

    protected void migrate(IProgressMonitor monitor) {
        monitor.beginTask("", this.projects.size());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        for (Object o : this.projects) {
            IProject project = (IProject)o;
            this.migrate((IProgressMonitor)subMonitor.newChild(1), project);
        }
        monitor.done();
    }

    protected abstract void migrate(IProgressMonitor var1, IProject var2);

    protected abstract boolean showConfirmationDialog();

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.projects = ss.toList();
        boolean validSelection = true;
        Iterator<?> iterator = this.projects.iterator();
        while (iterator.hasNext() && validSelection) {
            Object object = iterator.next();
            if (!(object instanceof IProject)) continue;
            IProject prj = (IProject)object;
            if (prj.isOpen()) {
                try {
                    if (!prj.hasNature(this.getNature())) continue;
                }
                catch (CoreException coreException) {
                    validSelection = false;
                }
                continue;
            }
            validSelection = false;
        }
        action.setEnabled(validSelection);
        if (!validSelection) {
            this.projects = null;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }
}

