/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors.xml;

import java.io.InputStream;
import java.util.Set;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.StandardXmlArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.ValueAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.eclipse.virgo.bundlor.util.ClassNameUtils;
import org.eclipse.virgo.util.math.Sets;

public final class HibernateMappingArtifactAnalyzer
implements ArtifactAnalyzer {
    private static final Set<String> BASIC_HIBERNATE_TYPES = Sets.asSet((Object[])new String[]{"integer", "long", "short", "float", "double", "character", "byte", "boolean", "yes_no", "true_false", "string", "date", "time", "timestamp", "calendar", "calendar_date", "big_decimal", "big_integer", "locale", "timezone", "currency", "class", "binary", "text", "serializable", "clob", "blob", "imm_date", "imm_time", "imm_timestamp", "imm_calendar", "imm_calendar_date", "imm_serializable", "imm_binary"});
    private static final Set<String> GENERATOR_TYPES = Sets.asSet((Object[])new String[]{"increment", "identity", "sequence", "hilo", "seqhilo", "uuid", "guid", "native", "assigned", "select", "foreign", "sequence-identity"});
    private static final String PACKAGE_EXPRESSION = "//hibernate-mapping/@package";
    private static final String CLASS_EXPRESSION = "//class/@name | //id/@type | //generator/@class | //composite-id/@class | //discriminator/@type | //version/@type | //property/@type | //many-to-one/@class | //one-to-one/@class | //one-to-many/@class | //many-to-many/@class | //component/@class | //dynamic-component/@class | //subclass/@name | //joined-subclass/@name | //union-subclass/@name | //import/@class";

    @Override
    public void analyse(InputStream artifact, String artifactName, PartialManifest partialManifest) throws Exception {
        StandardXmlArtifactAnalyzer analyzer = new StandardXmlArtifactAnalyzer(artifact);
        PackagePrefixValueAnalyzer packagePrefixValueAnalyzer = new PackagePrefixValueAnalyzer();
        analyzer.analyzeValues(PACKAGE_EXPRESSION, packagePrefixValueAnalyzer);
        analyzer.analyzeValues(CLASS_EXPRESSION, new HibernateValueAnalyzer(packagePrefixValueAnalyzer.getPackagePrefix(), partialManifest));
    }

    @Override
    public boolean canAnalyse(String artefactName) {
        return artefactName.endsWith(".hbm");
    }

    private static class HibernateValueAnalyzer
    implements ValueAnalyzer {
        private final String packagePrefix;
        private final PartialManifest partialManifest;

        public HibernateValueAnalyzer(String packagePrefix, PartialManifest partialManifest) {
            this.packagePrefix = packagePrefix;
            this.partialManifest = partialManifest;
        }

        @Override
        public void analyse(String value) {
            String candidateType;
            if (!BASIC_HIBERNATE_TYPES.contains(value) && !GENERATOR_TYPES.contains(value) && ClassNameUtils.isValidFqn(candidateType = value.contains(".") ? value.trim() : String.valueOf(this.packagePrefix) + "." + value.trim())) {
                this.partialManifest.recordReferencedType(candidateType);
            }
        }
    }

    private static class PackagePrefixValueAnalyzer
    implements ValueAnalyzer {
        private volatile String packagePrefix = "";

        private PackagePrefixValueAnalyzer() {
        }

        @Override
        public void analyse(String value) {
            this.packagePrefix = value;
        }

        public String getPackagePrefix() {
            return this.packagePrefix;
        }
    }
}

