/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl.heap;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;

public final class HeapDumpContributor
implements DumpContributor {
    private final Method heapDumpMethod;
    private final Object diagnosticMBean;

    public HeapDumpContributor() {
        Method heapDumpMethod = null;
        Object diagnosticMBean = null;
        try {
            Class<?> managementFactoryClass = Class.forName("sun.management.ManagementFactory", true, HeapDumpContributor.class.getClassLoader());
            Method method = managementFactoryClass.getMethod("getDiagnosticMXBean", new Class[0]);
            diagnosticMBean = method.invoke(null, new Object[0]);
            heapDumpMethod = diagnosticMBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Exception exception) {
            heapDumpMethod = null;
            diagnosticMBean = null;
        }
        this.heapDumpMethod = heapDumpMethod;
        this.diagnosticMBean = diagnosticMBean;
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        block9: {
            try {
                if (this.heapDumpMethod != null && this.diagnosticMBean != null) {
                    this.heapDumpMethod.invoke(this.diagnosticMBean, dump.createFile("heap.out").getAbsolutePath(), true);
                    break block9;
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(dump.createFileWriter("heap.err"));
                    writer.println("Diagnostic MXBean is not available. Heap dump cannot be generated.");
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw new DumpContributionFailedException("Failed to generate heap dump contribution", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new DumpContributionFailedException("Failed to generate heap dump contribution", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new DumpContributionFailedException("Failed to generate heap dump contribution", (Throwable)e);
            }
        }
    }

    public String getName() {
        return "heap";
    }
}

