/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.bindings;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;

public class StandardUndeployer
implements AppLifeCycle.Binding {
    public String[] getBindingTargets() {
        return new String[]{"undeploying"};
    }

    public void processBinding(Node node, App app) throws Exception {
        ContextHandler handler = app.getContextHandler();
        ContextHandlerCollection chcoll = app.getDeploymentManager().getContexts();
        this.recursiveRemoveContext((HandlerCollection)chcoll, handler);
    }

    private void recursiveRemoveContext(HandlerCollection coll, ContextHandler context) {
        Handler[] children = coll.getHandlers();
        int originalCount = children.length;
        for (Handler child : children) {
            Log.debug((String)("Child handler: " + child));
            if (child.equals(context)) {
                Log.debug((String)("Removing handler: " + child));
                coll.removeHandler(child);
                child.destroy();
                Log.debug((String)String.format("After removal: %d (originally %d)", coll.getHandlers().length, originalCount));
                continue;
            }
            if (!(child instanceof HandlerCollection)) continue;
            this.recursiveRemoveContext((HandlerCollection)child, context);
        }
    }
}

