/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.osgi.context.internal.classloader.ChainedClassLoader;
import org.springframework.osgi.context.internal.classloader.ClassLoaderFactory;
import org.springframework.osgi.service.importer.support.AbstractOsgiServiceImportFactoryBean;

abstract class AbstractServiceImporterProxyFactoryBean
extends AbstractOsgiServiceImportFactoryBean
implements SmartFactoryBean {
    private boolean initialized = false;
    private Object proxy;
    private ChainedClassLoader aopClassLoader;

    AbstractServiceImporterProxyFactoryBean() {
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Class[] intfs = this.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            Class intf = intfs[i];
            this.aopClassLoader.addClassLoader(intf);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Runnable callback = this.getProxyDestructionCallback();
        try {
            if (callback != null) {
                callback.run();
            }
        }
        finally {
            this.proxy = null;
        }
    }

    public Object getObject() {
        if (!this.initialized) {
            throw new FactoryBeanNotInitializedException();
        }
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    abstract Object createProxy();

    abstract Runnable getProxyDestructionCallback();

    ClassLoader getAopClassLoader() {
        return this.aopClassLoader;
    }

    public void setBeanClassLoader(final ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AbstractServiceImporterProxyFactoryBean.this.aopClassLoader = ClassLoaderFactory.getAopClassLoaderFor(classLoader);
                return null;
            }
        });
    }
}

