/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.internal.ExistingNodeLocator;
import org.eclipse.virgo.kernel.deployer.model.GCRoots;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphInclosure;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

public class PlanResolver
implements Transformer {
    private static final String PROVISIONING_PROPERTY_NAME = "org.eclipse.virgo.kernel.provisioning";
    private static final String SCOPE_SEPARATOR = "-";
    private final InstallArtifactGraphInclosure installArtifactGraphInclosure;
    private final GCRoots gcRoots;
    private final Repository repository;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public PlanResolver(@NonNull InstallArtifactGraphInclosure installArtifactGraphInclosure, @NonNull GCRoots gcRoots, @NonNull Repository repository, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull EventLogger eventLogger) {
        EventLogger eventLogger2 = eventLogger;
        ArtifactIdentityDeterminer artifactIdentityDeterminer2 = artifactIdentityDeterminer;
        Repository repository2 = repository;
        GCRoots gCRoots = gcRoots;
        InstallArtifactGraphInclosure installArtifactGraphInclosure2 = installArtifactGraphInclosure;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)installArtifactGraphInclosure2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)gCRoots);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)repository2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)artifactIdentityDeterminer2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)eventLogger2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.installArtifactGraphInclosure = installArtifactGraphInclosure;
            this.gcRoots = gcRoots;
            this.repository = repository;
            this.artifactIdentityDeterminer = artifactIdentityDeterminer;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException>(){
                    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                    {
                        try {
                            try {
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                            return;
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                    }

                    public boolean visit(GraphNode<InstallArtifact> graph) throws DeploymentException {
                        try {
                            try {
                                1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                                PlanResolver.access$0(PlanResolver.this, (InstallArtifact)graph.getValue());
                                boolean bl = true;
                                1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                                return bl;
                            }
                            catch (Throwable throwable) {
                                1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                                throw throwable;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                    }

                    static {
                        Factory factory = new Factory("PlanResolver.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver$1"));
                        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "visit", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver$1", "org.eclipse.virgo.util.common.GraphNode:", "graph:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "boolean"), 86);
                        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver$1");
                    }
                });
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void operate(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PlanInstallArtifact planInstallArtifact;
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                if (installArtifact instanceof PlanInstallArtifact && (planInstallArtifact = (PlanInstallArtifact)installArtifact).getGraph().getChildren().isEmpty()) {
                    try {
                        String scopeName = this.getArtifactScopeName(planInstallArtifact);
                        GraphNode<InstallArtifact> graph = planInstallArtifact.getGraph();
                        List<ArtifactSpecification> artifactSpecifications = planInstallArtifact.getArtifactSpecifications();
                        for (ArtifactSpecification artifactSpecification : artifactSpecifications) {
                            GraphNode<InstallArtifact> childInstallNode = this.obtainInstallArtifactGraph(artifactSpecification, scopeName, planInstallArtifact.getProvisioning());
                            boolean newNode = childInstallNode.getParents().isEmpty() && !((AbstractInstallArtifact)childInstallNode.getValue()).getTopLevelDeployed();
                            graph.addChild(childInstallNode);
                            if (!newNode) continue;
                            InstallArtifact childInstallArtifact = (InstallArtifact)childInstallNode.getValue();
                            ((AbstractInstallArtifact)childInstallArtifact).beginInstall();
                        }
                    }
                    catch (DeploymentException de) {
                        throw new DeploymentException("Deployment of " + planInstallArtifact + " failed: " + de.getMessage(), (Throwable)de);
                    }
                }
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getArtifactScopeName(InstallArtifact installArtifact) {
        try {
            PlanInstallArtifact planInstallArtifact;
            boolean scoped;
            if (installArtifact instanceof PlanInstallArtifact && (scoped = (planInstallArtifact = (PlanInstallArtifact)installArtifact).isScoped())) {
                return String.valueOf(planInstallArtifact.getName()) + SCOPE_SEPARATOR + PlanResolver.versionToShortString(planInstallArtifact.getVersion());
            }
            return installArtifact.getScopeName();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String versionToShortString(Version version) {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String result = version.toString();
                while (result.endsWith(".0")) {
                    result = result.substring(0, result.length() - 2);
                }
                String string = result;
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return string;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private GraphNode<InstallArtifact> obtainInstallArtifactGraph(ArtifactSpecification artifactSpecification, String scopeName, PlanDescriptor.Provisioning parentProvisioning) throws DeploymentException {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                GraphNode<InstallArtifact> sharedNode = null;
                ArtifactIdentity identity = null;
                File artifact = null;
                Map<String, String> properties = this.determineDeploymentProperties(artifactSpecification.getProperties(), parentProvisioning);
                String repositoryName = null;
                URI uri = artifactSpecification.getUri();
                if (uri == null) {
                    RepositoryAwareArtifactDescriptor repositoryAwareArtifactDescriptor = this.lookup(artifactSpecification);
                    if (repositoryAwareArtifactDescriptor == null) {
                        VersionRange versionRange;
                        String name;
                        String type = artifactSpecification.getType();
                        sharedNode = this.findSharedNode(type, name = artifactSpecification.getName(), versionRange = artifactSpecification.getVersionRange(), null);
                        if (sharedNode == null) {
                            this.eventLogger.log((LogEvent)DeployerLogEvents.ARTIFACT_NOT_FOUND, new Object[]{type, name, versionRange, this.repository.getName()});
                            throw new DeploymentException(String.valueOf(type) + " '" + name + "' in version range '" + versionRange + "' not found");
                        }
                    } else {
                        URI artifactUri = repositoryAwareArtifactDescriptor.getUri();
                        artifact = new File(artifactUri);
                        identity = new ArtifactIdentity(repositoryAwareArtifactDescriptor.getType(), repositoryAwareArtifactDescriptor.getName(), repositoryAwareArtifactDescriptor.getVersion(), scopeName);
                        repositoryName = repositoryAwareArtifactDescriptor.getRepositoryName();
                        sharedNode = this.findSharedNode(identity);
                    }
                } else {
                    try {
                        artifact = new File(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new DeploymentException("Invalid artifact specification URI", (Throwable)e);
                    }
                    identity = this.determineIdentity(uri, scopeName);
                    sharedNode = this.findSharedNode(identity);
                }
                GraphNode<InstallArtifact> graphNode = sharedNode == null ? this.installArtifactGraphInclosure.constructGraphNode(identity, artifact, properties, repositoryName) : sharedNode;
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return graphNode;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Map<String, String> determineDeploymentProperties(Map<String, String> properties, PlanDescriptor.Provisioning parentProvisioning) {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                HashMap<String, String> deploymentProperties = new HashMap<String, String>(properties);
                deploymentProperties.put(PROVISIONING_PROPERTY_NAME, parentProvisioning.toString());
                HashMap<String, String> hashMap = deploymentProperties;
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return hashMap;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private RepositoryAwareArtifactDescriptor lookup(ArtifactSpecification specification) throws DeploymentException {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                String type = specification.getType();
                String name = specification.getName();
                VersionRange versionRange = specification.getVersionRange();
                RepositoryAwareArtifactDescriptor repositoryAwareArtifactDescriptor = this.repository.get(type, name, versionRange);
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return repositoryAwareArtifactDescriptor;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity determineIdentity(URI artifactUri, String scopeName) throws DeploymentException {
        try {
            try {
                ArtifactIdentity artifactIdentity;
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                try {
                    File artifact = new File(artifactUri);
                    if (!artifact.exists()) {
                        throw new DeploymentException(artifact + " does not exist");
                    }
                    artifactIdentity = this.determineIdentity(artifact, scopeName);
                }
                catch (Exception e) {
                    throw new DeploymentException(String.valueOf(e.getMessage()) + ": uri='" + artifactUri + "'", (Throwable)e);
                }
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return artifactIdentity;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity determineIdentity(File file, String scopeName) throws DeploymentException {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(file, scopeName);
                if (artifactIdentity == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.INDETERMINATE_ARTIFACT_TYPE, new Object[]{file});
                    throw new DeploymentException("Cannot determine the artifact identity of the file '" + file + "'");
                }
                ArtifactIdentity artifactIdentity2 = artifactIdentity;
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return artifactIdentity2;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private GraphNode<InstallArtifact> findSharedNode(ArtifactIdentity artifactIdentity) {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                GraphNode<InstallArtifact> graphNode = ExistingNodeLocator.findSharedNode(this.gcRoots, artifactIdentity);
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return graphNode;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public GraphNode<InstallArtifact> findSharedNode(String type, String name, VersionRange versionRange, String scopeName) {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
                GraphNode<InstallArtifact> graphNode = ExistingNodeLocator.findSharedNode(this.gcRoots, type, name, versionRange, scopeName);
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
                return graphNode;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$0(PlanResolver arg0, InstallArtifact arg1) throws DeploymentException {
        try {
            try {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
                arg0.operate(arg1);
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
                return;
            }
            catch (Throwable throwable) {
                PlanResolver.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("PlanResolver.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transform", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.eclipse.virgo.util.common.GraphNode:org.eclipse.virgo.kernel.install.environment.InstallEnvironment:", "installGraph:installEnvironment:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "operate", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "arg0:arg1:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "versionToShortString", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.osgi.framework.Version:", "version:", "", "java.lang.String"), 141);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "obtainInstallArtifactGraph", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.eclipse.virgo.kernel.artifact.ArtifactSpecification:java.lang.String:org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor$Provisioning:", "artifactSpecification:scopeName:parentProvisioning:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.GraphNode"), 150);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineDeploymentProperties", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "java.util.Map:org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor$Provisioning:", "properties:parentProvisioning:", "", "java.util.Map"), 191);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lookup", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.eclipse.virgo.kernel.artifact.ArtifactSpecification:", "specification:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor"), 197);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineIdentity", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "java.net.URI:java.lang.String:", "artifactUri:scopeName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 206);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineIdentity", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "java.io.File:java.lang.String:", "file:scopeName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 218);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findSharedNode", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:", "artifactIdentity:", "", "org.eclipse.virgo.util.common.GraphNode"), 229);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findSharedNode", "org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver", "java.lang.String:java.lang.String:org.eclipse.virgo.util.osgi.manifest.VersionRange:java.lang.String:", "type:name:versionRange:scopeName:", "", "org.eclipse.virgo.util.common.GraphNode"), 233);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.PlanResolver");
    }
}

