/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.web.context.ServletRequestContext;
import org.apache.webbeans.web.context.SessionContextManager;

public class CdiAppContextsService
extends AbstractContextsService
implements ContextsService {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), CdiAppContextsService.class);
    private final ThreadLocal<RequestContext> requestContext = new ThreadLocal();
    private final ThreadLocal<SessionContext> sessionContext = new ThreadLocal();
    private final SessionContextManager sessionCtxManager = new SessionContextManager();
    private final ThreadLocal<ConversationContext> conversationContext;
    private final DependentContext dependentContext = new DependentContext();
    private final ApplicationContext applicationContext = new ApplicationContext();
    private final SingletonContext singletonContext = new SingletonContext();

    public CdiAppContextsService() {
        this(WebBeansContext.currentInstance().getOpenWebBeansConfiguration().supportsConversation());
    }

    public CdiAppContextsService(boolean supportsConversation) {
        this.dependentContext.setActive(true);
        this.conversationContext = supportsConversation ? new ThreadLocal() : null;
        this.applicationContext.setActive(true);
        this.singletonContext.setActive(true);
    }

    public void init(Object initializeObject) {
        this.startContext(ApplicationScoped.class, initializeObject);
        this.startContext(Singleton.class, initializeObject);
    }

    public void destroy(Object destroyObject) {
        this.requestContext.set(null);
        this.requestContext.remove();
        this.sessionContext.set(null);
        this.sessionContext.remove();
        if (null != this.conversationContext) {
            this.conversationContext.set(null);
            this.conversationContext.remove();
        }
    }

    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.destroyRequestContext();
            } else if (scopeType.equals(SessionScoped.class)) {
                this.destroySessionContext((HttpSession)endParameters);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.destroyApplicationContext();
            } else if (!scopeType.equals(Dependent.class)) {
                if (scopeType.equals(Singleton.class)) {
                    this.destroySingletonContext();
                } else if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
                    this.destroyConversationContext();
                } else if (logger.isWarningEnabled()) {
                    logger.warning("CDI-OpenWebBeans container in OpenEJB does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
                }
            }
        }
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext();
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext();
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.getApplicationContext();
        }
        if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
            return this.getConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return this.dependentContext;
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getSingletonContext();
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.initRequestContext((ServletRequestEvent)startParameter);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.initSessionContext((HttpSession)startParameter);
            } else if (!scopeType.equals(ApplicationScoped.class) && !scopeType.equals(Dependent.class)) {
                if (scopeType.equals(Singleton.class)) {
                    this.initSingletonContext();
                } else if (this.supportsConversation() && scopeType.equals(ConversationScoped.class)) {
                    this.initConversationContext((ConversationContext)startParameter);
                } else if (logger.isWarningEnabled()) {
                    logger.warning("CDI-OpenWebBeans container in OpenEJB does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
                }
            }
        }
    }

    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class) || scopeType.equals(ConversationScoped.class) && this.supportsConversation();
    }

    private void initRequestContext(ServletRequestEvent event) {
        ServletRequestContext rq = new ServletRequestContext();
        rq.setActive(true);
        this.requestContext.set((RequestContext)rq);
        if (event != null) {
            HttpSession session;
            HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
            rq.setServletRequest(request);
            if (request != null && (session = request.getSession(false)) != null) {
                this.initSessionContext(session);
            }
        }
    }

    private void destroyRequestContext() {
        ELContextStore elStore;
        RequestContext context = this.getRequestContext();
        if (context != null) {
            context.destroy();
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.requestContext.set(null);
        this.requestContext.remove();
        if (null != this.conversationContext) {
            this.conversationContext.set(null);
            this.conversationContext.remove();
        }
    }

    private void initSessionContext(HttpSession session) {
        if (session == null) {
            return;
        }
        String sessionId = session.getId();
        SessionContext currentSessionContext = this.sessionCtxManager.getSessionContextWithSessionId(sessionId);
        if (currentSessionContext == null) {
            currentSessionContext = new SessionContext();
            this.sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
        }
        currentSessionContext.setActive(true);
        this.sessionContext.set(currentSessionContext);
    }

    private void destroySessionContext(HttpSession session) {
        if (session != null) {
            SessionContext context = this.sessionContext.get();
            if (context != null) {
                context.destroy();
            }
            this.sessionContext.set(null);
            this.sessionContext.remove();
            this.sessionCtxManager.destroySessionContextWithSessionId(session.getId());
        }
    }

    private void destroyApplicationContext() {
    }

    private void initSingletonContext() {
    }

    private void destroySingletonContext() {
    }

    private void initConversationContext(ConversationContext context) {
        if (context == null) {
            if (this.conversationContext.get() == null) {
                ConversationContext newContext = new ConversationContext();
                newContext.setActive(true);
                this.conversationContext.set(newContext);
            } else {
                this.conversationContext.get().setActive(true);
            }
        } else {
            context.setActive(true);
            this.conversationContext.set(context);
        }
    }

    private void destroyConversationContext() {
        ConversationContext context = this.getConversationContext();
        if (context != null) {
            context.destroy();
        }
        if (null != this.conversationContext) {
            this.conversationContext.set(null);
            this.conversationContext.remove();
        }
    }

    private RequestContext getRequestContext() {
        return this.requestContext.get();
    }

    private Context getSessionContext() {
        SessionContext context = this.sessionContext.get();
        if (context == null) {
            this.lazyStartSessionContext();
            context = this.sessionContext.get();
        }
        return context;
    }

    private ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private SingletonContext getSingletonContext() {
        return this.singletonContext;
    }

    private ConversationContext getConversationContext() {
        return this.conversationContext.get();
    }

    private Context lazyStartSessionContext() {
        if (logger.isDebugEnabled()) {
            logger.debug(">lazyStartSessionContext");
        }
        Context webContext = null;
        Context context = this.getCurrentContext(RequestScoped.class);
        if (context instanceof ServletRequestContext) {
            ServletRequestContext requestContext = (ServletRequestContext)context;
            HttpServletRequest servletRequest = requestContext.getServletRequest();
            if (null != servletRequest) {
                try {
                    HttpSession currentSession = servletRequest.getSession();
                    this.initSessionContext(currentSession);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Lazy SESSION context initialization SUCCESS");
                    }
                }
                catch (Exception e) {
                    logger.error("ERROR_0013", e);
                }
            } else {
                logger.warning("Could NOT lazily initialize session context because NO active request context");
            }
        } else {
            logger.warning("Could NOT lazily initialize session context because of " + context + " RequestContext");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<lazyStartSessionContext " + webContext);
        }
        return webContext;
    }

    private boolean supportsConversation() {
        return this.conversationContext != null;
    }
}

