/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.management;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiRequiredBundle;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public class JMXQuasiWire {
    private final String namespace;
    private final long providerId;
    private final long requirerId;
    private final Map<String, String> bundleCapabilityAttributes;
    private final Map<String, String> bundleCapabilityDirectives;
    private final Map<String, String> bundleRequirementAttributes;
    private final Map<String, String> bundleRequirementDirectives;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public JMXQuasiWire(QuasiImportPackage quasiImportPackage) {
        this.namespace = "osgi.wiring.package";
        this.requirerId = quasiImportPackage.getImportingBundle().getBundleId();
        QuasiExportPackage provider = quasiImportPackage.getProvider();
        if (provider != null) {
            this.providerId = quasiImportPackage.getProvider().getExportingBundle().getBundleId();
            this.bundleCapabilityAttributes = this.stringifyMap(provider.getAttributes());
            this.bundleCapabilityDirectives = this.stringifyMap(provider.getDirectives());
        } else {
            this.providerId = -1L;
            this.bundleCapabilityAttributes = new HashMap<String, String>();
            this.bundleCapabilityDirectives = new HashMap<String, String>();
        }
        this.bundleRequirementAttributes = this.stringifyMap(quasiImportPackage.getAttributes());
        this.bundleRequirementDirectives = this.stringifyMap(quasiImportPackage.getDirectives());
    }

    public JMXQuasiWire(QuasiBundle provider, QuasiBundle requirer) {
        this.namespace = "osgi.wiring.host";
        this.providerId = provider.getBundleId();
        this.requirerId = requirer.getBundleId();
        this.bundleCapabilityAttributes = new HashMap<String, String>();
        this.bundleCapabilityDirectives = new HashMap<String, String>();
        this.bundleRequirementAttributes = this.getProperties({"host", provider.getSymbolicName()}, {"bundle-version", provider.getVersion().toString()});
        this.bundleRequirementDirectives = new HashMap<String, String>();
    }

    public JMXQuasiWire(QuasiRequiredBundle provider, QuasiBundle requirer) {
        this.namespace = "osgi.wiring.bundle";
        QuasiBundle quasiProvider = provider.getProvider();
        this.providerId = quasiProvider == null ? -1L : quasiProvider.getBundleId();
        this.requirerId = requirer.getBundleId();
        this.bundleCapabilityAttributes = this.stringifyMap(provider.getAttributes());
        this.bundleCapabilityDirectives = this.stringifyMap(provider.getDirectives());
        this.bundleRequirementAttributes = this.getProperties({"Required-Bundle", provider.getRequiredBundleName()}, {"Version-Constraint", provider.getVersionConstraint().toString()});
        this.bundleRequirementDirectives = new HashMap<String, String>();
    }

    public final long getRequirerBundleId() {
        return this.requirerId;
    }

    public final long getProviderBundleId() {
        return this.providerId;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final Map<String, String> getBundleCapabilityAttributes() {
        return this.bundleCapabilityAttributes;
    }

    public final Map<String, String> getBundleCapabilityDirectives() {
        return this.bundleCapabilityDirectives;
    }

    public final Map<String, String> getBundleRequirementAttributes() {
        return this.bundleRequirementAttributes;
    }

    public final Map<String, String> getBundleRequirementDirectives() {
        return this.bundleRequirementDirectives;
    }

    private Map<String, String> stringifyMap(Map<String, Object> map) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue().getClass().isArray()) {
                Object[] valueArray = (Object[])entry.getValue();
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < valueArray.length) {
                    builder.append(valueArray[i].toString());
                    if (i < valueArray.length - 1) {
                        builder.append(", ");
                    }
                    ++i;
                }
                properties.put(entry.getKey(), builder.toString());
                continue;
            }
            properties.put(entry.getKey(), entry.getValue().toString());
        }
        return properties;
    }

    private Map<String, String> getProperties(String[] ... strings) {
        HashMap<String, String> properties = new HashMap<String, String>();
        int i = 0;
        while (i < strings.length) {
            properties.put(strings[i][0], strings[i][1]);
            ++i;
        }
        return properties;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiWire");
    }
}

