/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.properties;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.builder.AttributeBuilder;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationAdmin;

public final class PropertiesBridge
implements ArtifactBridge {
    static final String PROPERTIES_SUFFIX = ".properties";
    static final String ARTIFACT_TYPE = "configuration";
    private final HashGenerator hashGenerator;
    private final ConfigurationAdmin configAdmin;

    public PropertiesBridge(HashGenerator hashGenerator, ConfigurationAdmin configAdmin) {
        this.hashGenerator = hashGenerator;
        this.configAdmin = configAdmin;
    }

    public ArtifactDescriptor generateArtifactDescriptor(File artifactFile) throws ArtifactGenerationException {
        if (artifactFile.getName().endsWith(PROPERTIES_SUFFIX)) {
            ArtifactDescriptor artifactDescriptor;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(artifactFile), StandardCharsets.UTF_8);
                Properties properties = new Properties();
                properties.load(reader);
                artifactDescriptor = this.createArtifactDescriptor(artifactFile, properties);
            }
            catch (IOException e) {
                try {
                    throw new ArtifactGenerationException("Failed processing properties file", ARTIFACT_TYPE, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
            return artifactDescriptor;
        }
        return null;
    }

    private ArtifactDescriptor createArtifactDescriptor(File propertiesFile, Properties properties) throws IOException {
        String name = properties.getProperty("service.factoryPid");
        if (StringUtils.hasText((String)name)) {
            return this.buildForManagedServiceFactoryConfiguration(propertiesFile, name, properties);
        }
        name = properties.getProperty("service.pid");
        if (!StringUtils.hasText((String)name)) {
            String fileName = propertiesFile.getName();
            name = fileName.substring(0, fileName.length() - PROPERTIES_SUFFIX.length());
        }
        return this.buildAtrifactDescriptor(propertiesFile, name).build();
    }

    private ArtifactDescriptor buildForManagedServiceFactoryConfiguration(File propertiesFile, String factoryPid, Properties properties) throws IOException {
        String pid = this.configAdmin.createFactoryConfiguration(factoryPid, null).getPid();
        ArtifactDescriptorBuilder builder = this.buildAtrifactDescriptor(propertiesFile, pid);
        builder.addAttribute(new AttributeBuilder().setName("service.factoryPid").setValue(factoryPid).build());
        return builder.build();
    }

    private ArtifactDescriptorBuilder buildAtrifactDescriptor(File propertiesFile, String name) {
        ArtifactDescriptorBuilder artifactDescriptorBuilder = new ArtifactDescriptorBuilder();
        artifactDescriptorBuilder.setUri(propertiesFile.toURI()).setType(ARTIFACT_TYPE).setName(name).setVersion(Version.emptyVersion);
        this.hashGenerator.generateHash(artifactDescriptorBuilder, propertiesFile);
        return artifactDescriptorBuilder;
    }
}

