/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceDelegate;
import org.eclipse.virgo.kernel.services.concurrent.KernelExecutorService;
import org.eclipse.virgo.kernel.services.concurrent.ThreadPoolUtils;
import org.eclipse.virgo.kernel.shim.serviceability.TracingService;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public final class KernelThreadPoolExecutor
extends ThreadPoolExecutor
implements KernelExecutorService {
    private final ExecutorServiceDelegate delegate;
    private final String poolName;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public KernelThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String poolName, TracingService tracingService) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, poolName, tracingService, null);
    }

    public KernelThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String poolName, TracingService tracingService, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ThreadPoolUtils.createThreadFactory(poolName), ThreadPoolUtils.determineHandler(handler));
        this.poolName = poolName;
        this.delegate = new ExecutorServiceDelegate(tracingService);
    }

    @Override
    public void execute(Runnable command) {
        try {
            KernelThreadPoolExecutor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Runnable decorated = this.delegate.decorate(command);
            super.execute(decorated);
            KernelThreadPoolExecutor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            KernelThreadPoolExecutor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Override
    public long getAverageExecutionTime() {
        return this.delegate.getAverageExecutionTime(this.getCompletedTaskCount());
    }

    @Override
    public long getExecutionTime() {
        return this.delegate.getExecutionTime();
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    static {
        Factory factory = new Factory("KernelThreadPoolExecutor.java", Class.forName("org.eclipse.virgo.kernel.services.concurrent.KernelThreadPoolExecutor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "org.eclipse.virgo.kernel.services.concurrent.KernelThreadPoolExecutor", "java.lang.Runnable:", "command:", "", "void"), 78);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.KernelThreadPoolExecutor");
    }
}

