/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.war.deployer;

import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

public class WebBundleUtils {
    public static boolean isWebApplicationBundle(BundleManifest manifest) {
        return WebBundleUtils.specifiesBundleSymbolicName(manifest) || WebBundleUtils.specifiesBundleVersion(manifest) || WebBundleUtils.specifiesBundleManifestVersion(manifest) || WebBundleUtils.specifiesImportPackage(manifest) || WebBundleUtils.specifiesWebContextPath(manifest);
    }

    public static String calculateCorrectSymbolicName(String originalName) {
        if (originalName != null) {
            return WebBundleUtils.replaceForbiddenChars(originalName, '.');
        }
        return "";
    }

    private static String replaceForbiddenChars(String st, char newChar) {
        char[] inpuStringChars = st.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = inpuStringChars;
        int n = inpuStringChars.length;
        int n2 = 0;
        while (n2 < n) {
            char currentChar = cArray[n2];
            if (WebBundleUtils.isCharAllowedInSymbolicNames(currentChar)) {
                sb.append(currentChar);
            } else {
                sb.append(newChar);
            }
            ++n2;
        }
        return sb.toString();
    }

    private static boolean isCharAllowedInSymbolicNames(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '.';
    }

    private static boolean specifiesBundleSymbolicName(BundleManifest manifest) {
        return manifest.getBundleSymbolicName().getSymbolicName() != null;
    }

    private static boolean specifiesBundleVersion(BundleManifest manifest) {
        return manifest.getHeader("Bundle-Version") != null;
    }

    private static boolean specifiesBundleManifestVersion(BundleManifest manifest) {
        return manifest.getBundleManifestVersion() != 1;
    }

    private static boolean specifiesImportPackage(BundleManifest manifest) {
        return !manifest.getImportPackage().getImportedPackages().isEmpty();
    }

    private static boolean specifiesWebContextPath(BundleManifest manifest) {
        return manifest.getHeader("Web-ContextPath") != null;
    }
}

