/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DecoratorUtil;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebBeansDecoratorConfig {
    private static Logger logger = WebBeansLoggerFacade.getLogger(WebBeansDecoratorConfig.class);

    private WebBeansDecoratorConfig() {
    }

    public static <T> void configureDecoratorClass(AbstractInjectionTargetBean<T> delegate) {
        if (delegate.getScope() != Dependent.class && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0005_1", delegate.getBeanClass().getName());
        }
        if (delegate.getName() != null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0005_2", delegate.getBeanClass().getName());
        }
        if (delegate.isAlternative() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0005_3", delegate.getBeanClass().getName());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Configuring decorator class : [{0}]", delegate.getReturnType());
        }
        WebBeansDecorator<T> decorator = new WebBeansDecorator<T>(delegate);
        delegate.getWebBeansContext().getBeanManagerImpl().addDecorator(decorator);
    }

    public static void configureDecorators(AbstractInjectionTargetBean<?> component) {
        if (!component.getDecoratorStack().isEmpty()) {
            return;
        }
        Set<Annotation> qualifiers = component.getQualifiers();
        Annotation[] anns = new Annotation[qualifiers.size()];
        anns = qualifiers.toArray(anns);
        List<Decorator<?>> decoratorList = component.getWebBeansContext().getBeanManagerImpl().resolveDecorators(component.getTypes(), anns);
        if (decoratorList != null && !decoratorList.isEmpty()) {
            DecoratorUtil.checkManagedBeanDecoratorConditions(component, decoratorList);
            for (WebBeansDecorator webBeansDecorator : decoratorList) {
                component.getDecoratorStack().add(webBeansDecorator);
            }
            WebBeansDecoratorConfig.filterDecoratorsPerBDA(component, component.getDecoratorStack());
        }
    }

    private static void filterDecoratorsPerBDA(AbstractInjectionTargetBean<?> component, List<Decorator<?>> stack) {
        ScannerService scannerService = component.getWebBeansContext().getScannerService();
        if (!scannerService.isBDABeansXmlScanningEnabled()) {
            return;
        }
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        String beanBDABeansXML = beansXMLScanner.getBeansXml(component.getBeanClass());
        Set definedDecorators = beansXMLScanner.getDecorators(beanBDABeansXML);
        if (stack != null && stack.size() > 0) {
            Iterator<Decorator<?>> it = stack.iterator();
            while (it.hasNext()) {
                WebBeansDecorator dec = (WebBeansDecorator)it.next();
                if (definedDecorators.contains(dec.getClazz())) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getDecoratorStack(InjectionTargetBean<?> component, Object instance, Object delegate, CreationalContextImpl<?> ownerCreationalContext) {
        Object object = instance;
        synchronized (object) {
            ArrayList<Object> decoratorStack = new ArrayList<Object>();
            List<Decorator<?>> decoratorList = component.getDecoratorStack();
            Iterator<Decorator<?>> itList = decoratorList.iterator();
            BeanManagerImpl manager = component.getWebBeansContext().getBeanManagerImpl();
            while (itList.hasNext()) {
                WebBeansDecorator decorator = (WebBeansDecorator)itList.next();
                Object decoratorInstance = ownerCreationalContext.getDependentDecorator(instance, (Contextual<?>)decorator);
                if (decoratorInstance == null) {
                    decoratorInstance = manager.getReference(decorator, decorator.getBeanClass(), ownerCreationalContext);
                    decorator.setInjections(decoratorInstance, ownerCreationalContext);
                    decorator.setDelegate(decoratorInstance, delegate);
                    ownerCreationalContext.addDependent(instance, decorator, decoratorInstance);
                }
                decoratorStack.add(decoratorInstance);
            }
            return decoratorStack;
        }
    }

    public static Set<Decorator<?>> findDeployedWebBeansDecorator(BeanManagerImpl beanManagerImpl, Set<Type> apiType, Annotation ... anns) {
        HashSet set = new HashSet();
        Iterator<Decorator<?>> it = Collections.unmodifiableSet(beanManagerImpl.getDecorators()).iterator();
        WebBeansDecorator decorator = null;
        ArrayList<Class<? extends Annotation>> bindingTypes = new ArrayList<Class<? extends Annotation>>();
        HashSet<Annotation> listAnnot = new HashSet<Annotation>();
        for (Annotation ann : anns) {
            bindingTypes.add(ann.annotationType());
            listAnnot.add(ann);
        }
        if (listAnnot.isEmpty()) {
            listAnnot.add((Annotation)((Object)new DefaultLiteral()));
        }
        while (it.hasNext()) {
            decorator = (WebBeansDecorator)it.next();
            if (!decorator.isDecoratorMatch(apiType, listAnnot)) continue;
            set.add(decorator);
        }
        return set;
    }
}

