/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;

public class Zips {
    public static void unzip(File zipFile, File destination) throws IOException {
        Zips.unzip(zipFile, destination, false);
    }

    public static void unzip(File zipFile, File destination, boolean noparent) throws IOException {
        Files.dir(destination);
        Files.writable(destination);
        Files.file(zipFile);
        Files.readable(zipFile);
        try {
            ZipEntry entry;
            ZipInputStream in = IO.unzip(zipFile);
            while ((entry = in.getNextEntry()) != null) {
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                File file = new File(destination, path);
                if (entry.isDirectory()) {
                    Files.mkdir(file);
                    continue;
                }
                Files.mkdir(file.getParentFile());
                IO.copy((InputStream)in, file);
                long lastModified = entry.getTime();
                if (lastModified <= 0L) continue;
                file.setLastModified(lastModified);
            }
            in.close();
        }
        catch (IOException e) {
            throw new IOException("Unable to unzip " + zipFile.getAbsolutePath(), e);
        }
    }
}

