/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jolokia.backend.MBeanServerHandler;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.RequestHandlerManager;
import org.jolokia.history.HistoryStore;
import org.jolokia.mbean.Config;
import org.jolokia.request.JmxRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.DebugStore;
import org.jolokia.util.LogHandler;

public class LocalRequestDispatcher
implements RequestDispatcher {
    private MBeanServerHandler mBeanServerHandler;
    private RequestHandlerManager requestHandlerManager;
    private String qualifier;

    public LocalRequestDispatcher(Converters pConverters, Restrictor pRestrictor, String pQualifier, LogHandler pLogHandler) {
        this.mBeanServerHandler = new MBeanServerHandler(pQualifier, pLogHandler);
        this.qualifier = pQualifier;
        this.requestHandlerManager = new RequestHandlerManager(pConverters, this.mBeanServerHandler.getServerHandle(), pRestrictor);
    }

    public boolean canHandle(JmxRequest pJmxRequest) {
        return true;
    }

    public boolean useReturnValueWithPath(JmxRequest pJmxRequest) {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxRequest.getType());
        return handler.useReturnValueWithPath();
    }

    public Object dispatchRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxReq.getType());
        return this.mBeanServerHandler.dispatchRequest(handler, pJmxReq);
    }

    public void init(HistoryStore pHistoryStore, DebugStore pDebugStore) throws MalformedObjectNameException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        this.mBeanServerHandler.init();
        String oName = this.createObjectNameWithQualifier("jolokia:type=Config");
        Config config = new Config(pHistoryStore, pDebugStore, oName);
        this.mBeanServerHandler.registerMBean(config, oName);
        String legacyOName = this.createObjectNameWithQualifier("jmx4perl:type=Config");
        Config legacyConfig = new Config(pHistoryStore, pDebugStore, legacyOName);
        this.mBeanServerHandler.registerMBean(legacyConfig, legacyOName);
    }

    public void destroy() throws JMException {
        this.mBeanServerHandler.unregisterMBeans();
    }

    public ServerHandle getServerInfo() {
        return this.mBeanServerHandler.getServerHandle();
    }

    private String createObjectNameWithQualifier(String pOName) {
        return pOName + (this.qualifier != null ? "," + this.qualifier : "");
    }
}

