/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.infomodel.tests.formatter;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.impl.InformationModelPackageImpl;
import org.eclipse.vorto.editor.infomodel.tests.InformationModelInjectorProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=InformationModelInjectorProvider.class)
public class InfoModellFormatterTest
extends AbstractXtextTests {
    @Inject
    @Extension
    private ParseHelper<InformationModel> parserHelper;
    @Inject
    @Extension
    private INodeModelFormatter formatter;

    @BeforeClass
    public static void initializeModel() {
        InformationModelPackageImpl.init();
    }

    @Test
    public void testFormattingForBasicBlock() {
        String expectedText = this.getFormattedColorLamp();
        String rawText = this.getUnFormattedColorLamp();
        this.assertFormattedAs(rawText, expectedText);
    }

    public String getFormattedColorLamp() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example");
        _builder.newLine();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"ColorLamp\"");
        _builder.newLine();
        _builder.append((Object)"description \"Information model for a standard color lamp.\"");
        _builder.newLine();
        _builder.append((Object)"category example");
        _builder.newLine();
        _builder.append((Object)"using eclipse.vorto.basic.BinarySwitch ; 1.0.0");
        _builder.newLine();
        _builder.append((Object)"using com.mycompany.fb.RGBColorPicker ; 1.0.0");
        _builder.newLine();
        _builder.append((Object)"using com.mycompany.fb.Dimmer ; 1.0.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"infomodel ColorLamp {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"functionblocks {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"binaryswitch as BinarySwitch");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"rgbcolorpicker as RGBColorPicker");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dimmer as Dimmer");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }

    public String getUnFormattedColorLamp() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example version 1.0.0 ");
        _builder.newLine();
        _builder.append((Object)"displayname \"ColorLamp\" description \"Information model for a standard color lamp.\" category example \t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"using eclipse.vorto.basic.BinarySwitch ; 1.0.0 using com.mycompany.fb.RGBColorPicker ; 1.0.0 using com.mycompany.fb.Dimmer ; 1.0.0");
        _builder.newLine();
        _builder.append((Object)"infomodel ColorLamp {functionblocks {binaryswitch as BinarySwitch rgbcolorpicker as RGBColorPicker ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dimmer as Dimmer");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }

    public void assertFormattedAs(CharSequence input, CharSequence expected) {
        try {
            String expectedText = expected.toString();
            InformationModel _parse = (InformationModel)this.parserHelper.parse(input);
            Resource _eResource = _parse.eResource();
            IParseResult _parseResult = ((XtextResource)_eResource).getParseResult();
            ICompositeNode _rootNode = _parseResult.getRootNode();
            int _length = input.length();
            INodeModelFormatter.IFormattedRegion _format = this.formatter.format(_rootNode, 0, _length);
            String formattedText = _format.getFormattedText();
            Assert.assertEquals((Object)expectedText, (Object)formattedText);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

