/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractWizardPage
extends WizardPage {
    public static final String PROJECTNAME_REGEX = "[^a-zA-Z0-9 \\._]";
    public static final String MODEL_NAME_REGEX = "[A-Z][a-zA-Z0-9_]*$";
    public static final String VERSION_REGEX = "^\\d+\\.\\d+\\.\\d+(-\\w+)*$";

    protected AbstractWizardPage(String pageName) {
        super(pageName);
    }

    protected AbstractWizardPage(String pageName, String title, ImageDescriptor descriptor) {
        super(pageName, title, descriptor);
    }

    protected String getWindowTitle() {
        return "";
    }

    protected boolean checkProjectName(String projectName) {
        if (this.checkForRegexPattern(projectName, true, PROJECTNAME_REGEX)) {
            this.setErrorMessage("Project name should not contain special characters.");
            return false;
        }
        return true;
    }

    protected boolean checkForRegexPattern(String input, boolean expectedBool, String regexPattern) {
        return Pattern.compile(regexPattern).matcher(input).matches() == expectedBool;
    }

    protected boolean validateStrExist(String string, String errorMsgToBeShown) {
        if (Strings.isNullOrEmpty((String)string)) {
            this.setErrorMessage(errorMsgToBeShown);
            return false;
        }
        return true;
    }

    protected boolean validateExistingSameProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProject(this.getProjectName()).exists()) {
            this.setErrorMessage("Project " + this.getProjectName() + " already exists.");
            return false;
        }
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(projectName);
        if (projectLocation.toFile().exists()) {
            try {
                String canonicalPath = projectLocation.toFile().getCanonicalPath();
                projectLocation = new Path(canonicalPath);
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(projectName)) {
                    this.setErrorMessage("Project " + this.getProjectName() + " already exists.");
                    return false;
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected abstract String getProjectName();
}

