/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.prosystfi.tasks;

import org.eclipse.vorto.codegen.api.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.prosystfi.templates.FunctionalItemImplTemplate;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;

public class FunctionalItemImplGeneratorTask
extends AbstractTemplateGeneratorTask<FunctionblockModel> {
    public static final String FI_IMPL_PACKAGE = "impl";
    public static final String SUFFIX = "Impl";
    private String javaFileExtension;
    private String targetPath;
    private String targetPackage;
    private String[] imports;

    public FunctionalItemImplGeneratorTask(String javaFileExtension, String srcBase, String interfacePackage, String ... imports) {
        this.javaFileExtension = javaFileExtension;
        this.targetPackage = String.valueOf(interfacePackage) + '.' + FI_IMPL_PACKAGE;
        this.targetPath = String.valueOf(srcBase) + '/' + this.targetPackage.replace('.', '/');
        if (imports != null && imports.length > 0) {
            this.imports = new String[imports.length + 1];
            System.arraycopy(imports, 0, this.imports, 0, imports.length);
        } else {
            this.imports = new String[1];
        }
        this.imports[this.imports.length - 1] = interfacePackage;
    }

    public String getFileName(FunctionblockModel fbm) {
        return String.valueOf(fbm.getName()) + SUFFIX + this.javaFileExtension;
    }

    public String getPath(FunctionblockModel fbm) {
        return this.targetPath;
    }

    public ITemplate<FunctionblockModel> getTemplate() {
        return new FunctionalItemImplTemplate(this.targetPackage, this.imports);
    }
}

