/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.listener;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.ui.selection.listener.SelectionListener;
import org.eclipse.dali.ui.selection.notification.ISelectionNotification;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CompilationUnitListener
extends SelectionListener
implements IPartListener {
    private ITextEditor editor;

    public CompilationUnitListener(ITextEditor anEditor) {
        this.editor = anEditor;
        this.editor.getSite().getPage().addPartListener((IPartListener)this);
    }

    public Object getView() {
        return this.editor;
    }

    public void selectionChanged(ISelectionNotification aNotification) {
        if (aNotification.getEvent() == SelectionNotificationEvent.SELECTION_CHANGED && this.editor.getSite().getPage().getActiveEditor() == this.editor) {
            PersistenceSourceRefElement eObj = (PersistenceSourceRefElement)aNotification.getSelection();
            ITextRange range = eObj.getTextRange();
            this.editor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.editor)) {
            this.deregister();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

