/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.tracker;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.dali.ui.selection.resolver.DaliSelectionResolver;
import org.eclipse.dali.ui.selection.tracker.PartSelectionTracker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CompilationUnitSelectionTracker
extends PartSelectionTracker {
    private PersistenceFile file;
    private static DaliSelectionResolver RESOLVER = new DaliSelectionResolver();
    private PropertyListener listener = new PropertyListener();

    public CompilationUnitSelectionTracker(ITextEditor part) {
        super((IWorkbenchPart)part);
        part.addPropertyListener((IPropertyListener)this.listener);
        this.file = PersistenceUiPlugin.getPlugin().getPersistenceManager().persistenceFileForInput(part.getEditorInput());
    }

    private void handlePropertyChange(ITextEditor editor, int propId) {
        if (editor == this.part && propId == 258) {
            this.updateInput(editor);
        }
    }

    private void updateInput(ITextEditor editor) {
        EObject eObj = this.getEObjectAt(editor.getSite().getSelectionProvider().getSelection());
        Collection coll = this.getEObjectsAt(eObj);
        this.notifyChanged(SelectionNotificationEvent.CLOSED, eObj, coll, editor);
        this.file = PersistenceUiPlugin.getPlugin().getPersistenceManager().persistenceFileForInput(editor.getEditorInput());
        eObj = this.getEObjectAt(editor.getSite().getSelectionProvider().getSelection());
        coll = this.getEObjectsAt(eObj);
        this.notifyChanged(SelectionNotificationEvent.OPENED, eObj, coll, editor);
    }

    protected EObject getEObjectAt(ISelection aSelection) {
        ITextSelection aTextSelection = (ITextSelection)aSelection;
        PersistenceSourceRefElement eObj = this.file.persistenceObjectAt(aTextSelection.getOffset());
        Assert.isNotNull((Object)eObj);
        return eObj;
    }

    protected Collection getEObjectsAt(EObject anEObj) {
        return RESOLVER.resolve(anEObj);
    }

    protected void addListener() {
        ITextEditor anEditor = (ITextEditor)this.part;
        IPostSelectionProvider provider = (IPostSelectionProvider)anEditor.getSelectionProvider();
        provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void removeListener() {
        ITextEditor anEditor = (ITextEditor)this.part;
        IPostSelectionProvider provider = (IPostSelectionProvider)anEditor.getSelectionProvider();
        provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
    }

    private class PropertyListener
    implements IPropertyListener {
        private PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            CompilationUnitSelectionTracker.this.handlePropertyChange((ITextEditor)source, propId);
        }
    }
}

