## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(TableContainer)

## -----------------------------------------------------------------------------
# Example data
tbl <- matrix(1:12, nrow = 3, ncol = 4)
row_dt <- data.frame(row1 = 1:3, row2 = letters[1:3])
col_dt <- data.frame(col1 = 1:4, col2 = letters[1:4])
meta_dt <- list(meta1 = "meta1", meta2 = "meta2")

# Create a TableContainer
container <- TableContainer(
  table = tbl,
  rowData = row_dt,
  colData = col_dt,
  metaData = meta_dt
)

# Check the container
container

## -----------------------------------------------------------------------------
subset <- container[1:2, 2:4]
subset

## -----------------------------------------------------------------------------
rowData(subset)
colData(subset)

## -----------------------------------------------------------------------------
container[1, ]

## -----------------------------------------------------------------------------
container[1]

## -----------------------------------------------------------------------------
container[, 2]

## -----------------------------------------------------------------------------
container[1, 2]

## -----------------------------------------------------------------------------
# Access data
tblData(container)
rowData(container)
colData(container)
metaData(container)

# Modify data
tblData(container) <- matrix(13:24, nrow = 3, ncol = 4)
rowData(container) <- data.frame(newRow = 1:3)
colData(container) <- data.frame(newCol = 1:4)
metaData(container) <- list(newMeta = "updated metadata")

## check the updated container
container

## -----------------------------------------------------------------------------
tbl <- data.frame(
    x = c(1, 123, 123456678, 1235678887644),
    y = c("abc", "this is a long string", "another long string", "yet another long string"),
    z = c(TRUE, FALSE, TRUE, FALSE)
)
format_tbl(tbl, max_tbl_width = 50, max_row = 2)

## -----------------------------------------------------------------------------
## within length limit, no change
common_formatter(12345678901234567890, max_len = 20)

## use scientific notation to keep it shorter
common_formatter(12345678901234567890, max_len = 10)

## within length limit, no change
common_formatter("this is a long string", max_len = 40)

## truncate the string and append with ...
common_formatter("this is a long string", max_len = 20)

