## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(cld)

## ----example-shared-----------------------------------------------------------
# Example with shared letters
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)
cld_result <- make_cld(result)
cld_result

## ----pattern-examples-1-------------------------------------------------------
set.seed(123)
data1 <- data.frame(
  value = c(rnorm(10, 10, 1), rnorm(10, 20, 1), rnorm(10, 30, 1)),
  group = rep(c("Low", "Medium", "High"), each = 10)
)
make_cld(pairwise.t.test(data1$value, data1$group))

## ----pattern-examples-2-------------------------------------------------------
set.seed(455)
data2 <- data.frame(
  value = c(rnorm(10, 10, 1.5), rnorm(10, 10.1, 1.5), rnorm(10, 20, 1.5)),
  group = rep(c("A", "B", "C"), each = 10)
)
make_cld(pairwise.t.test(data2$value, data2$group))

## ----pattern-examples-3-------------------------------------------------------
set.seed(889)
data3 <- data.frame(
  value = c(rnorm(10, 10, 3), rnorm(10, 13, 3), rnorm(10, 16, 3), rnorm(10, 19, 3)),
  group = rep(c("G1", "G2", "G3", "G4"), each = 10)
)
make_cld(pairwise.t.test(data3$value, data3$group))

## ----alpha-comparison---------------------------------------------------------
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)

## ----alpha-comparison-1-------------------------------------------------------
make_cld(result, alpha = 0.05)   # Standard

## ----alpha-comparison-2-------------------------------------------------------
make_cld(result, alpha = 0.01)   # Stringent

## ----alpha-comparison-3-------------------------------------------------------
make_cld(result, alpha = 0.001)  # Very stringent

## ----metadata-----------------------------------------------------------------
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)
cld_result <- make_cld(result)

# Access stored information
attr(cld_result, "alpha")           # Significance level
attr(cld_result, "method")          # Statistical method
attr(cld_result, "n_comparisons")   # Total comparisons
attr(cld_result, "n_significant")   # Significant comparisons

