/*
 * Decompiled with CFR 0.152.
 */
package jdplus.spreadsheet.base.r;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jdplus.spreadsheet.base.api.SpreadSheetBean;
import jdplus.spreadsheet.base.api.SpreadSheetProvider;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsProvider;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.r.util.Providers;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.util.ObsFormat;
import lombok.Generated;

public final class SpreadSheets {
    private static final SpreadSheetProvider PROVIDER = new SpreadSheetProvider();

    private static SpreadSheetProvider currentProvider() {
        return TsFactory.getDefault().getProvider("XCLPRVDR").orElse(null);
    }

    public static String changeFile(String id, String nfile, String ofile) {
        Optional set = PROVIDER.toDataSet(TsMoniker.of((String)"XCLPRVDR", (String)id));
        Optional<String> m = set.map(d -> {
            SpreadSheetBean bean = PROVIDER.decodeBean(d.getDataSource());
            if (ofile.isEmpty() || bean.getFile().getName().equals(ofile)) {
                bean.setFile(Path.of(nfile, new String[0]).toFile());
                DataSource src = PROVIDER.encodeBean((Object)bean);
                DataSet nd = d.toBuilder().dataSource(src).build();
                return PROVIDER.toMoniker(nd).getId();
            }
            return id;
        });
        return m.orElse(id);
    }

    public static DataSource source(String file, ObsFormat obsFormat, ObsGathering obsGathering) {
        SpreadSheetBean bean = new SpreadSheetBean();
        bean.setFile(Path.of(file, new String[0]).toFile());
        if (obsFormat != null) {
            bean.setFormat(obsFormat);
        }
        if (obsGathering != null) {
            bean.setGathering(obsGathering);
        }
        return PROVIDER.encodeBean((Object)bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] sheets(DataSource source) throws IllegalArgumentException, IOException {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            String[] stringArray = (String[])sheets.stream().map(s -> currentProvider.getDisplayNodeName(s)).toArray(String[]::new);
            return stringArray;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] series(DataSource source, int sheet) throws IllegalArgumentException, IOException {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            if (sheet > sheets.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet ds = (DataSet)sheets.get(sheet - 1);
            List all = currentProvider.children(ds);
            String[] stringArray = (String[])all.stream().map(s -> currentProvider.getDisplayNodeName(s)).toArray(String[]::new);
            return stringArray;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ts series(DataSource source, int sheet, int series, boolean fullName) throws IllegalArgumentException, IOException {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            if (sheet > sheets.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet ds = (DataSet)sheets.get(sheet - 1);
            List all = currentProvider.children(ds);
            if (series > all.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet s = (DataSet)all.get(series - 1);
            TsMoniker moniker = currentProvider.toMoniker(s);
            Ts ts = currentProvider.getTs(moniker, TsInformationType.All).withName(fullName ? currentProvider.getDisplayName(s) : currentProvider.getDisplayNodeName(s));
            return ts;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ts seriesByName(DataSource source, String sheet, String series, boolean fullName) throws IllegalArgumentException, IOException {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            Optional<DataSet> csheet = sheets.stream().filter(s -> currentProvider.getDisplayName(s).equals(sheet)).findFirst();
            DataSet ds = csheet.orElseThrow(() -> new IllegalArgumentException("Invalid sheet"));
            List all = currentProvider.children(ds);
            DataSet q = all.stream().filter(s -> currentProvider.getDisplayName(s).equals(series)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid series"));
            TsMoniker moniker = currentProvider.toMoniker(q);
            Ts ts = currentProvider.getTs(moniker, TsInformationType.All).withName(fullName ? currentProvider.getDisplayName(q) : currentProvider.getDisplayNodeName(q));
            return ts;
        }
        finally {
            currentProvider.close(source);
        }
    }

    private static Ts of(SpreadSheetProvider provider, DataSet c) {
        TsMoniker moniker = provider.toMoniker(c);
        try {
            return provider.getTs(moniker, TsInformationType.All).withName(provider.getDisplayNodeName(c));
        }
        catch (IOException ex) {
            return Ts.builder().moniker(moniker).data(TsData.empty((String)"Unavailable")).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TsCollection collection(DataSource source, int sheet, boolean fullNames) throws IllegalArgumentException, IOException {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            if (sheet > sheets.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet ds = (DataSet)sheets.get(sheet - 1);
            TsMoniker moniker = currentProvider.toMoniker(ds);
            if (fullNames) {
                TsCollection tsCollection = currentProvider.getTsCollection(moniker, TsInformationType.All).withName(currentProvider.getDisplayName(ds));
                return tsCollection;
            }
            List schildren = currentProvider.children(ds);
            List<Ts> all = schildren.stream().map(c -> SpreadSheets.of(currentProvider, c)).toList();
            TsCollection tsCollection = TsCollection.builder().name(currentProvider.getDisplayName(ds)).moniker(moniker).items(all).build();
            return tsCollection;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TsCollection collectionByName(DataSource source, String sheet, boolean fullNames) throws IllegalArgumentException, IOException {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        try {
            currentProvider.open(source);
            List sheets = currentProvider.children(source);
            DataSet ds = sheets.stream().filter(s -> currentProvider.getDisplayName(s).equals(sheet)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid sheet"));
            TsMoniker moniker = currentProvider.toMoniker(ds);
            if (fullNames) {
                TsCollection tsCollection = currentProvider.getTsCollection(moniker, TsInformationType.All).withName(currentProvider.getDisplayName(ds));
                return tsCollection;
            }
            List schildren = currentProvider.children(ds);
            List<Ts> all = schildren.stream().map(c -> SpreadSheets.of(currentProvider, c)).toList();
            TsCollection tsCollection = TsCollection.builder().name(currentProvider.getDisplayName(ds)).moniker(moniker).items(all).build();
            return tsCollection;
        }
        finally {
            currentProvider.close(source);
        }
    }

    public static void setPaths(String[] paths) {
        SpreadSheetProvider provider = SpreadSheets.currentProvider();
        if (provider == null) {
            throw new RuntimeException("SpreadSheetProvider is not available");
        }
        File[] files = (File[])Arrays.stream(paths).map(p -> Path.of(p, new String[0]).toFile()).toArray(File[]::new);
        provider.setPaths(files);
    }

    public static void updateTsFactory() {
        SpreadSheetProvider currentProvider = SpreadSheets.currentProvider();
        if (currentProvider == null) {
            Providers.updateTsFactory((TsProvider[])new TsProvider[]{new SpreadSheetProvider()});
        }
    }

    public static DataSet decode(String id) {
        Optional set = PROVIDER.toDataSet(TsMoniker.of((String)"XCLPRVDR", (String)id));
        return set.orElse(null);
    }

    public static String encode(DataSet set) {
        return PROVIDER.toMoniker(set).getId();
    }

    public static SpreadSheetBean sourceOf(DataSet set) {
        return PROVIDER.decodeBean(set.getDataSource());
    }

    public static DataSet seriesDataSet(DataSource source, String sheetName, String seriesName) {
        return DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.SERIES).parameter("sheetName", sheetName).parameter("seriesName", seriesName).build();
    }

    public static DataSet sheetDataSet(DataSource source, String sheetName) {
        return DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.COLLECTION).parameter("sheetName", sheetName).build();
    }

    @Generated
    private SpreadSheets() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

