/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api;

import internal.spreadsheet.base.api.SpreadSheetParam;
import java.util.Locale;
import jdplus.spreadsheet.base.api.SpreadSheetBean;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;

public final class SpreadSheetDataDisplayName
implements HasDataDisplayName {
    private final String providerName;
    private final SpreadSheetParam resource;

    @NonNull
    public String getDisplayName(@NonNull DataSource dataSource) throws IllegalArgumentException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        SpreadSheetBean bean = (SpreadSheetBean)this.resource.get(dataSource);
        return bean.getFile().getPath() + SpreadSheetDataDisplayName.toString(bean.getGathering());
    }

    @NonNull
    public String getDisplayName(@NonNull DataSet dataSet) throws IllegalArgumentException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return this.getCollectionId(dataSet);
            }
            case SERIES: {
                return this.getCollectionId(dataSet) + "\n" + this.getSeriesId(dataSet);
            }
        }
        throw new IllegalArgumentException(dataSet.getKind().name());
    }

    @NonNull
    public String getDisplayNodeName(@NonNull DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return this.getCollectionId(dataSet);
            }
            case SERIES: {
                return this.getSeriesId(dataSet);
            }
        }
        throw new IllegalArgumentException(dataSet.getKind().name());
    }

    private String getCollectionId(DataSet dataSet) {
        return (String)this.resource.getSheetParam().get(dataSet);
    }

    private String getSeriesId(DataSet dataSet) {
        return (String)this.resource.getSeriesParam().get(dataSet);
    }

    private static String toString(ObsGathering gathering) {
        return TsUnit.UNDEFINED.equals((Object)gathering.getUnit()) ? "" : String.format(Locale.ROOT, "(%s/%s)", gathering.getUnit(), gathering.getAggregationType());
    }

    @Generated
    private SpreadSheetDataDisplayName(String providerName, SpreadSheetParam resource) {
        this.providerName = providerName;
        this.resource = resource;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull SpreadSheetDataDisplayName of(String providerName, SpreadSheetParam resource) {
        return new SpreadSheetDataDisplayName(providerName, resource);
    }
}

