/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import java.util.Arrays;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class Reflector {
    double alpha;
    double beta;
    private final double[] px;
    private int xstart;
    int n;

    double x0() {
        return this.px[this.xstart];
    }

    void x0(double value) {
        this.px[this.xstart] = value;
    }

    DataPointer x() {
        return DataPointer.of(this.px, this.xstart);
    }

    DataPointer v() {
        return DataPointer.of(this.px, this.xstart + 1);
    }

    Reflector(double[] x) {
        this.px = x;
    }

    void set(int start, int n) {
        this.xstart = start;
        this.n = n;
    }

    void larfg() {
        if (this.n == 0) {
            return;
        }
        double x0 = this.x0();
        int m = this.n - 1;
        DataPointer v = this.v();
        DataPointer x = this.x();
        double nrm = x.norm2(this.n);
        double eps = Constants.getEpsilon();
        double safemin = Constants.getSafeMin() / eps;
        int k = 0;
        if (nrm != 0.0 && nrm < safemin) {
            double rsafemin = 1.0 / safemin;
            do {
                v.mul(m, rsafemin);
                x0 *= rsafemin;
            } while ((nrm *= rsafemin) < safemin && ++k < 4);
            nrm = x.norm2(this.n);
        }
        if (x0 < 0.0) {
            nrm = -nrm;
        }
        for (int j = 0; j < k; ++j) {
            nrm *= safemin;
        }
        this.beta = nrm == 0.0 ? 0.0 : nrm / (nrm + x0);
        v.div(m, nrm);
        this.x0(1.0 + x0 / nrm);
        this.alpha = -nrm;
    }

    void lapply(FastMatrix M) {
        int nc = M.getColumnsCount();
        int lda = M.getColumnIncrement();
        int m = this.n - 1;
        int mstart = M.getStartPosition();
        double[] pm = M.getStorage();
        int xmax = this.xstart + this.n;
        int k = 0;
        int im = mstart;
        while (k < nc) {
            double s = pm[im] / this.beta;
            int i = this.xstart + 1;
            int j = im + 1;
            while (i < xmax) {
                s += pm[j] * this.px[i];
                ++i;
                ++j;
            }
            if (s != 0.0) {
                int n = im;
                pm[n] = pm[n] - s;
                s *= -this.beta;
                j = im + 1;
                for (i = this.xstart + 1; i < xmax; ++i) {
                    int n2 = j++;
                    pm[n2] = pm[n2] + s * this.px[i];
                }
            }
            ++k;
            im += lda;
        }
    }

    @Generated
    public double getAlpha() {
        return this.alpha;
    }

    @Generated
    public double getBeta() {
        return this.beta;
    }

    @Generated
    public double[] getPx() {
        return this.px;
    }

    @Generated
    public int getXstart() {
        return this.xstart;
    }

    @Generated
    public int getN() {
        return this.n;
    }

    @Generated
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Generated
    public void setBeta(double beta) {
        this.beta = beta;
    }

    @Generated
    public void setXstart(int xstart) {
        this.xstart = xstart;
    }

    @Generated
    public void setN(int n) {
        this.n = n;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reflector)) {
            return false;
        }
        Reflector other = (Reflector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta(), other.getBeta()) != 0) {
            return false;
        }
        if (this.getXstart() != other.getXstart()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        return Arrays.equals(this.getPx(), other.getPx());
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Reflector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        long $beta = Double.doubleToLongBits(this.getBeta());
        result = result * 59 + (int)($beta >>> 32 ^ $beta);
        result = result * 59 + this.getXstart();
        result = result * 59 + this.getN();
        result = result * 59 + Arrays.hashCode(this.getPx());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Reflector(alpha=" + this.getAlpha() + ", beta=" + this.getBeta() + ", px=" + Arrays.toString(this.getPx()) + ", xstart=" + this.getXstart() + ", n=" + this.getN() + ")";
    }
}

