/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class EstimateSpec
implements Validatable<EstimateSpec> {
    public static final EstimateSpec DEFAULT = (EstimateSpec)EstimateSpec.builder().build();
    public static final double DEF_TOL = 1.0E-7;
    @NonNull
    private final TimeSelector span;
    private final double tol;

    public static Builder builder() {
        return new Builder().span(TimeSelector.all()).tol(1.0E-7);
    }

    public EstimateSpec validate() throws IllegalArgumentException {
        return this;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    @Generated
    EstimateSpec(@NonNull TimeSelector span, double tol) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.span = span;
        this.tol = tol;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().span(this.span).tol(this.tol);
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public double getTol() {
        return this.tol;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstimateSpec)) {
            return false;
        }
        EstimateSpec other = (EstimateSpec)o;
        if (Double.compare(this.getTol(), other.getTol()) != 0) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !this$span.equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tol = Double.doubleToLongBits(this.getTol());
        result = result * 59 + (int)($tol >>> 32 ^ $tol);
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "EstimateSpec(span=" + String.valueOf(this.getSpan()) + ", tol=" + this.getTol() + ")";
    }

    public static class Builder
    implements Validatable.Builder<EstimateSpec> {
        @Generated
        private TimeSelector span;
        @Generated
        private double tol;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tol(double tol) {
            this.tol = tol;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull EstimateSpec buildWithoutValidation() {
            return new EstimateSpec(this.span, this.tol);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "EstimateSpec.Builder(span=" + String.valueOf(this.span) + ", tol=" + this.tol + ")";
        }
    }
}

