## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  warning = FALSE,
  message = FALSE
)

## ----eval=FALSE---------------------------------------------------------------
# install.packages("cowfootR")

## ----eval=FALSE---------------------------------------------------------------
# devtools::install_github("juanmarcosmoreno-arch/cowfootR")

## -----------------------------------------------------------------------------
library(cowfootR)

## -----------------------------------------------------------------------------
boundaries <- set_system_boundaries("farm_gate")
boundaries

## -----------------------------------------------------------------------------
enteric <- calc_emissions_enteric(
  n_animals = 100,
  cattle_category = "dairy_cows",
  boundaries = boundaries
)
enteric

## -----------------------------------------------------------------------------
manure <- calc_emissions_manure(
  n_cows = 100,
  boundaries = boundaries
)
manure

## -----------------------------------------------------------------------------
soil <- calc_emissions_soil(
  n_fertilizer_synthetic = 1500,
  n_excreta_pasture = 5000,
  area_ha = 120,
  boundaries = boundaries
)
soil

## -----------------------------------------------------------------------------
energy <- calc_emissions_energy(
  diesel_l = 2000,
  electricity_kwh = 5000,
  boundaries = boundaries
)
energy

## -----------------------------------------------------------------------------
inputs <- calc_emissions_inputs(
  conc_kg = 1000,
  fert_n_kg = 500,
  boundaries = boundaries
)
inputs

## -----------------------------------------------------------------------------
total_emissions <- calc_total_emissions(
  enteric,
  manure,
  soil,
  energy,
  inputs
)
total_emissions

## -----------------------------------------------------------------------------
milk_intensity <- calc_intensity_litre(
  total_emissions = total_emissions,
  milk_litres = 750000,
  fat = 4.0,
  protein = 3.3
)
milk_intensity

## -----------------------------------------------------------------------------
area_intensity <- calc_intensity_area(
  total_emissions = total_emissions,
  area_total_ha = 120
)
area_intensity

