## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----example------------------------------------------------------------------
library(optsize)
# Load field yield data
data <- system.file("extdata", "data.csv", package = "optsize")
mat <- read.csv(data, header = FALSE)
df_mat <- as.matrix(data)
df_mat <- apply(df_mat, 2, as.numeric)
mode(df_mat)  # should return "numeric"
# Generate possible plot shapes
res <- generate_plot_shapes(mat)
res

# Fit variance law to determine optimum plot size
out_var <- fit_variance_law(mat)
print(out_var$plots)
out_var

# Fertility analysis
ferti <- ferti_analysis(mat)
print(ferti$heatmap)
ferti

