/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.roots;

import internal.toolkit.base.core.math.functions.gsl.roots.FSolver;
import internal.toolkit.base.core.math.functions.gsl.roots.GslRootException;
import java.util.function.DoubleUnaryOperator;

public class FalsePosSolver
extends FSolver {
    private double fLower;
    private double fUpper;

    public FalsePosSolver(DoubleUnaryOperator fn, double xLower, double xUpper) {
        this.function = fn;
        this.lower = xLower;
        this.upper = xUpper;
        this.root = 0.5 * (xLower + xUpper);
        this.fLower = fn.applyAsDouble(xLower);
        this.fUpper = fn.applyAsDouble(xUpper);
        if (this.fLower < 0.0 && this.fUpper < 0.0 || this.fLower > 0.0 && this.fUpper > 0.0) {
            throw new GslRootException("Endpoints do not straddle y=0");
        }
    }

    @Override
    public void iterate() {
        double w;
        double xLeft = this.lower;
        double xRight = this.upper;
        double f_lower = this.fLower;
        double f_upper = this.fUpper;
        if (f_lower == 0.0) {
            this.root = xLeft;
            this.upper = xLeft;
            return;
        }
        if (f_upper == 0.0) {
            this.root = xRight;
            this.lower = xRight;
            return;
        }
        double xLinear = xRight - f_upper * (xLeft - xRight) / (f_lower - f_upper);
        double fLinear = this.function.applyAsDouble(xLinear);
        if (fLinear == 0.0) {
            this.root = xLinear;
            this.lower = xLinear;
            this.upper = xLinear;
            return;
        }
        if (f_lower > 0.0 && fLinear < 0.0 || f_lower < 0.0 && fLinear > 0.0) {
            this.root = xLinear;
            this.upper = xLinear;
            this.fUpper = fLinear;
            w = xLinear - xLeft;
        } else {
            this.root = xLinear;
            this.lower = xLinear;
            this.fLower = fLinear;
            w = xRight - xLinear;
        }
        if (w < 0.5 * (xRight - xLeft)) {
            return;
        }
        double xBisect = 0.5 * (xLeft + xRight);
        double fBisect = this.function.applyAsDouble(xBisect);
        if (f_lower > 0.0 && fBisect < 0.0 || f_lower < 0.0 && fBisect > 0.0) {
            this.upper = xBisect;
            this.fUpper = fBisect;
            if (this.root > xBisect) {
                this.root = 0.5 * (xLeft + xBisect);
            }
        } else {
            this.lower = xBisect;
            this.fLower = fBisect;
            if (this.root < xBisect) {
                this.root = 0.5 * (xBisect + xRight);
            }
        }
    }
}

