/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.outlier;

import jdplus.toolkit.base.api.util.TableOfBoolean;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;

public abstract class SingleOutlierDetector<T extends IArimaModel> {
    private final RobustStandardDeviationComputer sdevComputer;
    private IOutlierFactory[] factories;
    private double[] weights;
    protected int lbound;
    protected int ubound;
    protected FastMatrix T;
    protected FastMatrix coef;
    private RegArimaModel<T> regarima;
    private TableOfBoolean allowedTable;
    private int posMax = -1;
    private int oMax = -1;

    public boolean process(RegArimaModel<T> model) {
        if (this.factories == null) {
            return false;
        }
        this.regarima = model;
        this.clear(false);
        return this.calc();
    }

    protected SingleOutlierDetector(RobustStandardDeviationComputer sdevComputer) {
        this.sdevComputer = sdevComputer;
    }

    public void setOutlierFactories(IOutlierFactory[] factories, double[] weights) {
        this.factories = factories;
        if (weights == null) {
            this.weights = new double[factories.length];
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = 1.0;
            }
        } else {
            this.weights = weights;
        }
        this.clear(true);
    }

    public void setOutlierFactories(IOutlierFactory ... factories) {
        this.factories = factories;
        this.weights = new double[factories.length];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = 1.0;
        }
        this.clear(true);
    }

    public RobustStandardDeviationComputer getStandardDeviationComputer() {
        return this.sdevComputer;
    }

    protected abstract boolean calc();

    protected void clear(boolean all) {
        this.oMax = -1;
        this.posMax = -1;
        if (all) {
            this.T = null;
            this.coef = null;
            this.allowedTable = null;
        } else if (this.T != null) {
            this.T.set(0.0);
            this.coef.set(0.0);
        }
    }

    public double coefficient(int pos, int outlier) {
        return this.coef.get(pos, outlier);
    }

    public void exclude(int pos, int ioutlier) {
        if (pos >= 0 && pos < this.allowedTable.getRowsCount() && ioutlier >= 0) {
            this.allowedTable.set(pos, ioutlier, false);
            this.T.set(pos, ioutlier, Double.NaN);
        }
    }

    public void allow(int pos, int ioutlier) {
        if (pos >= 0 && pos < this.allowedTable.getRowsCount() && ioutlier >= 0) {
            this.allowedTable.set(pos, ioutlier, true);
            this.T.set(pos, ioutlier, 0.0);
        }
    }

    public void exclude(int[] pos) {
        if (pos == null) {
            return;
        }
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < this.factories.length; ++j) {
                this.exclude(pos[i], j);
            }
        }
    }

    public void allow(int[] pos) {
        if (pos == null) {
            return;
        }
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < this.factories.length; ++j) {
                this.allow(pos[i], j);
            }
        }
    }

    public void exclude(int pos) {
        for (int j = 0; j < this.factories.length; ++j) {
            this.exclude(pos, j);
        }
    }

    public int getLBound() {
        return this.lbound;
    }

    public int getMaxOutlierType() {
        if (this.oMax == -1) {
            this.searchMax();
        }
        return this.oMax;
    }

    public int getMaxOutlierPosition() {
        if (this.posMax == -1) {
            this.searchMax();
        }
        return this.posMax;
    }

    public double getMaxTStat() {
        if (this.oMax == -1) {
            this.searchMax();
        }
        double tmax = this.T(this.posMax, this.oMax);
        return tmax;
    }

    public int getOutlierFactoriesCount() {
        return this.factories.length;
    }

    public IOutlierFactory[] getOutliersFactories() {
        return this.factories;
    }

    public IOutlierFactory getOutlierFactory(int i) {
        return this.factories[i];
    }

    public int getUBound() {
        return this.ubound;
    }

    public boolean isAllowed(int pos, int outlier) {
        return this.allowedTable.get(pos, outlier);
    }

    public void setBounds(int lbound, int ubound) {
        this.lbound = lbound;
        this.ubound = ubound;
    }

    public void prepare(int n) {
        this.lbound = 0;
        this.ubound = n;
        this.T = FastMatrix.make(n, this.factories.length);
        this.coef = FastMatrix.make(n, this.factories.length);
        this.allowedTable = new TableOfBoolean(n, this.factories.length);
        for (int i = 0; i < this.factories.length; ++i) {
            IOutlierFactory fac = this.factories[i];
            int jstart = fac.excludingZoneAtStart();
            int jend = n - fac.excludingZoneAtEnd();
            for (int j = jstart; j < jend; ++j) {
                this.allowedTable.set(j, i, true);
            }
        }
    }

    private void searchMax() {
        if (this.T == null) {
            return;
        }
        double max = 0.0;
        int imax = -1;
        double[] table = this.T.getStorage();
        int i = 0;
        for (int c = 0; c < this.T.getColumnsCount(); ++c) {
            double w = this.weights[c];
            int r = 0;
            while (r < this.T.getRowsCount()) {
                double cur = Math.abs(table[i]) * w;
                if (cur > max) {
                    imax = i;
                    max = cur;
                }
                ++r;
                ++i;
            }
            if (imax != -1) continue;
            return;
        }
        this.posMax = imax % this.T.getRowsCount();
        this.oMax = imax / this.T.getRowsCount();
    }

    protected void setT(int pos, int outlier, double val) {
        this.T.set(pos, outlier, val);
    }

    protected void setCoefficient(int pos, int outlier, double val) {
        this.coef.set(pos, outlier, val);
    }

    public double T(int pos, int outlier) {
        return this.T.get(pos, outlier);
    }

    public double getWeight(int pos) {
        return this.weights[pos];
    }

    public int getLbound() {
        return this.lbound;
    }

    public int getUbound() {
        return this.ubound;
    }

    public FastMatrix getT() {
        return this.T;
    }

    public FastMatrix allCoefficients() {
        return this.coef;
    }

    void allow(int pos, String code) {
        for (int i = 0; i < this.factories.length; ++i) {
            IOutlierFactory outlier = this.factories[i];
            if (!outlier.getCode().equals(code)) continue;
            this.allow(pos - this.lbound, i);
            return;
        }
    }

    void exclude(int pos, String code) {
        for (int i = 0; i < this.factories.length; ++i) {
            IOutlierFactory factory = this.factories[i];
            if (!factory.getCode().equals(code)) continue;
            this.exclude(pos - this.lbound, i);
            return;
        }
    }

    public RegArimaModel<T> getRegArima() {
        return this.regarima;
    }
}

