/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.ObsList;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntUnaryOperator;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;

interface ByLongObsList
extends ObsList {
    public void clear();

    public void add(long var1, double var3);

    public static final class PreSorted
    implements ByLongObsList {
        private final ToPeriodIdFunc tsPeriodIdFunc;
        private long[] periods;
        private double[] values;
        private int size;

        PreSorted(ToPeriodIdFunc tsPeriodIdFunc, int initialCapacity) {
            this.tsPeriodIdFunc = tsPeriodIdFunc;
            this.periods = new long[initialCapacity];
            this.values = new double[initialCapacity];
            this.size = 0;
        }

        private void grow() {
            int oldCapacity = this.periods.length;
            int newCapacity = Math.min(oldCapacity * 2, Integer.MAX_VALUE);
            this.periods = Arrays.copyOf(this.periods, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public void add(long period, double value) {
            if (this.size + 1 == this.periods.length) {
                this.grow();
            }
            this.periods[this.size] = period;
            this.values[this.size] = value;
            ++this.size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public double getValue(int index) {
            return this.values[index];
        }

        @Override
        public IntUnaryOperator getPeriodIdFunc(TsUnit unit, LocalDateTime reference) {
            return o -> this.tsPeriodIdFunc.apply(unit, reference, this.periods[o]);
        }

        @Override
        public void sortByPeriod() {
        }

        @Override
        public Doubles getValues() {
            return Doubles.ofInternal(Arrays.copyOf(this.values, this.size));
        }
    }

    public static final class Sortable
    implements ByLongObsList {
        private final ToPeriodIdFunc tsPeriodIdFunc;
        private final List<LongObs> list;
        private boolean sorted;
        private long latestPeriod;

        Sortable(ToPeriodIdFunc tsPeriodIdFunc) {
            this.tsPeriodIdFunc = tsPeriodIdFunc;
            this.list = new ArrayList<LongObs>();
            this.sorted = true;
            this.latestPeriod = Long.MIN_VALUE;
        }

        boolean isSorted() {
            return this.sorted;
        }

        @Override
        public void clear() {
            this.list.clear();
            this.sorted = true;
            this.latestPeriod = Long.MIN_VALUE;
        }

        @Override
        public void add(long period, double value) {
            this.list.add(new LongObs(period, value));
            this.sorted = this.sorted && this.latestPeriod <= period;
            this.latestPeriod = period;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public double getValue(int index) {
            return this.list.get((int)index).value;
        }

        @Override
        public IntUnaryOperator getPeriodIdFunc(TsUnit unit, LocalDateTime reference) {
            return o -> this.tsPeriodIdFunc.apply(unit, reference, this.list.get((int)o).period);
        }

        @Override
        public void sortByPeriod() {
            if (!this.sorted) {
                this.list.sort((l, r) -> Long.compare(l.period, r.period));
                this.sorted = true;
                this.latestPeriod = this.list.get((int)(this.list.size() - 1)).period;
            }
        }

        private static final class LongObs {
            final long period;
            final double value;

            @Generated
            public LongObs(long period, double value) {
                this.period = period;
                this.value = value;
            }
        }
    }

    public static interface ToPeriodIdFunc {
        public int apply(TsUnit var1, LocalDateTime var2, long var3);
    }
}

