/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.modelling;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataToolkit;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MovingRegression {
    public static Results regarima(TsData s, String td, int nyears) {
        int j;
        int period = s.getTsUnit().ratioOf(TsUnit.P1Y);
        SarimaOrders spec = SarimaOrders.airline((int)period);
        SarimaModel arima = SarimaModel.builder((SarimaOrders)spec).setDefault().build();
        DayClustering dc = MovingRegression.days(td);
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        FastMatrix x = Regression.matrix((TimeSeriesDomain)s.getDomain(), (ITsVariable[])new ITsVariable[]{new GenericTradingDaysVariable(gtd)});
        RegSarimaComputer monitor = RegSarimaComputer.builder().useParallelProcessing(true).useMaximumLikelihood(true).useCorrectedDegreesOfFreedom(false).precision(1.0E-12).build();
        RegArimaModel.Builder rbuilder = RegArimaModel.builder().y(s.getValues()).arima((IArimaModel)arima);
        x.columns().forEach(xx -> rbuilder.addX((DoubleSeq)xx));
        RegArimaEstimation rslt = monitor.process(rbuilder.build(), null);
        arima = (SarimaModel)rslt.getModel().arima();
        ArrayList<double[]> coef = new ArrayList<double[]>();
        TimeSelector sel = TimeSelector.first((int)(nyears * period));
        TsDomain dom = s.getDomain().select(sel);
        while (dom.end().isBefore(s.getDomain().end())) {
            FastMatrix mtd = MovingRegression.generate(dom, dc);
            TsData yc = TsDataToolkit.fitToDomain((TsData)s, (TsDomain)dom);
            RegArimaModel.Builder builder = RegArimaModel.builder().y(yc.getValues()).arima((IArimaModel)arima);
            mtd.columns().forEach(xx -> builder.addX((DoubleSeq)xx));
            ConcentratedLikelihoodWithMissing cll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(builder.build());
            coef.add(cll.coefficients().toArray());
            dom = dom.move(period);
        }
        FastMatrix cl = FastMatrix.make((int)s.length(), (int)x.getColumnsCount());
        cl.set(Double.NaN);
        for (j = 0; j < period * nyears / 2; ++j) {
            cl.row(j).copyFrom((double[])coef.get(0), 0);
        }
        for (int i = 1; i < coef.size(); ++i) {
            double[] a = (double[])coef.get(i - 1);
            double[] b = (double[])coef.get(i);
            int l = j;
            int k = 0;
            while (k < period) {
                for (int c = 0; c < a.length; ++c) {
                    double del = (b[c] - a[c]) / (double)period;
                    cl.set(j, c, a[c] + del * (double)(j - l));
                }
                ++k;
                ++j;
            }
        }
        double[] last = (double[])coef.get(coef.size() - 1);
        while (j < cl.getRowsCount()) {
            cl.row(j).copyFrom(last, 0);
            ++j;
        }
        return Results.builder().domain(s.getDomain()).arima(arima).coefficients(cl).variables(x).build();
    }

    public static DayClustering days(String td) {
        DayClustering dc = switch (td) {
            case "TD2" -> DayClustering.TD2;
            case "TD3" -> DayClustering.TD3;
            case "TD3c" -> DayClustering.TD3c;
            case "TD4" -> DayClustering.TD4;
            default -> DayClustering.TD7;
        };
        return dc;
    }

    private static FastMatrix generate(TsDomain domain, DayClustering dc) {
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{new GenericTradingDaysVariable(gtd)});
    }

    private static FastMatrix generateVar(DayClustering dc, String var) {
        int groupsCount = dc.getGroupsCount();
        FastMatrix full = FastMatrix.square((int)7);
        if (!var.equalsIgnoreCase("Contrasts")) {
            full.set(-0.14285714285714285);
        }
        full.diagonal().add(1.0);
        FastMatrix Q = FastMatrix.make((int)(groupsCount - 1), (int)7);
        int[] gdef = dc.getGroupsDefinition();
        for (int i = 1; i < groupsCount; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (gdef[j] != i) continue;
                Q.set(i - 1, j, 1.0);
            }
        }
        return SymmetricMatrix.XSXt((FastMatrix)full, (FastMatrix)Q);
    }

    @Generated
    private MovingRegression() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Results
    implements GenericExplorable {
        private final TsDomain domain;
        private final FastMatrix variables;
        private final FastMatrix coefficients;
        private final SarimaModel arima;
        private static final String ARIMA = "arima";
        private static final String LL = "likelihood";
        private static final String COEFF = "coefficients";
        private static final String TD = "td";
        private static final String TDEFFECT = "tdeffect";
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(){

            public Class getSourceClass() {
                return Results.class;
            }
        };

        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        public <T> T getData(String id, Class<T> tclass) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }

        public static final InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        @Generated
        Results(TsDomain domain, FastMatrix variables, FastMatrix coefficients, SarimaModel arima) {
            this.domain = domain;
            this.variables = variables;
            this.coefficients = coefficients;
            this.arima = arima;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public TsDomain getDomain() {
            return this.domain;
        }

        @Generated
        public FastMatrix getVariables() {
            return this.variables;
        }

        @Generated
        public FastMatrix getCoefficients() {
            return this.coefficients;
        }

        @Generated
        public SarimaModel getArima() {
            return this.arima;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            TsDomain this$domain = this.getDomain();
            TsDomain other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            FastMatrix this$variables = this.getVariables();
            FastMatrix other$variables = other.getVariables();
            if (this$variables == null ? other$variables != null : !this$variables.equals(other$variables)) {
                return false;
            }
            FastMatrix this$coefficients = this.getCoefficients();
            FastMatrix other$coefficients = other.getCoefficients();
            if (this$coefficients == null ? other$coefficients != null : !this$coefficients.equals(other$coefficients)) {
                return false;
            }
            SarimaModel this$arima = this.getArima();
            SarimaModel other$arima = other.getArima();
            return !(this$arima == null ? other$arima != null : !this$arima.equals(other$arima));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TsDomain $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            FastMatrix $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : $variables.hashCode());
            FastMatrix $coefficients = this.getCoefficients();
            result = result * 59 + ($coefficients == null ? 43 : $coefficients.hashCode());
            SarimaModel $arima = this.getArima();
            result = result * 59 + ($arima == null ? 43 : $arima.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "MovingRegression.Results(domain=" + String.valueOf(this.getDomain()) + ", variables=" + String.valueOf(this.getVariables()) + ", coefficients=" + String.valueOf(this.getCoefficients()) + ", arima=" + String.valueOf(this.getArima()) + ")";
        }

        static {
            MAPPING.set(COEFF, FastMatrix.class, r -> r.getCoefficients());
            MAPPING.set(TD, FastMatrix.class, r -> r.getVariables());
            MAPPING.set(TDEFFECT, TsData.class, r -> {
                DataBlock tmp = DataBlock.make((int)r.getDomain().length());
                DataBlock prod = DataBlock.make((int)r.getDomain().length());
                for (int i = 0; i < r.variables.getColumnsCount(); ++i) {
                    prod.set(r.getCoefficients().column(i), r.getVariables().column(i), (a, b) -> a * b);
                    tmp.add(prod);
                }
                return TsData.of((TsPeriod)r.getDomain().getStartPeriod(), (DoubleSeq)tmp);
            });
        }

        @Generated
        public static class Builder {
            @Generated
            private TsDomain domain;
            @Generated
            private FastMatrix variables;
            @Generated
            private FastMatrix coefficients;
            @Generated
            private SarimaModel arima;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder domain(TsDomain domain) {
                this.domain = domain;
                return this;
            }

            @Generated
            public @NonNull Builder variables(FastMatrix variables) {
                this.variables = variables;
                return this;
            }

            @Generated
            public @NonNull Builder coefficients(FastMatrix coefficients) {
                this.coefficients = coefficients;
                return this;
            }

            @Generated
            public @NonNull Builder arima(SarimaModel arima) {
                this.arima = arima;
                return this;
            }

            @Generated
            public @NonNull Results build() {
                return new Results(this.domain, this.variables, this.coefficients, this.arima);
            }

            @Generated
            public @NonNull String toString() {
                return "MovingRegression.Results.Builder(domain=" + String.valueOf(this.domain) + ", variables=" + String.valueOf(this.variables) + ", coefficients=" + String.valueOf(this.coefficients) + ", arima=" + String.valueOf(this.arima) + ")";
            }
        }
    }

    static class Airline {
        FastMatrix td;
        double regVariance;
        double theta;
        double btheta;

        @Generated
        public Airline() {
        }

        @Generated
        public FastMatrix getTd() {
            return this.td;
        }

        @Generated
        public double getRegVariance() {
            return this.regVariance;
        }

        @Generated
        public double getTheta() {
            return this.theta;
        }

        @Generated
        public double getBtheta() {
            return this.btheta;
        }

        @Generated
        public void setTd(FastMatrix td) {
            this.td = td;
        }

        @Generated
        public void setRegVariance(double regVariance) {
            this.regVariance = regVariance;
        }

        @Generated
        public void setTheta(double theta) {
            this.theta = theta;
        }

        @Generated
        public void setBtheta(double btheta) {
            this.btheta = btheta;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Airline)) {
                return false;
            }
            Airline other = (Airline)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getRegVariance(), other.getRegVariance()) != 0) {
                return false;
            }
            if (Double.compare(this.getTheta(), other.getTheta()) != 0) {
                return false;
            }
            if (Double.compare(this.getBtheta(), other.getBtheta()) != 0) {
                return false;
            }
            FastMatrix this$td = this.getTd();
            FastMatrix other$td = other.getTd();
            return !(this$td == null ? other$td != null : !this$td.equals(other$td));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Airline;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $regVariance = Double.doubleToLongBits(this.getRegVariance());
            result = result * 59 + (int)($regVariance >>> 32 ^ $regVariance);
            long $theta = Double.doubleToLongBits(this.getTheta());
            result = result * 59 + (int)($theta >>> 32 ^ $theta);
            long $btheta = Double.doubleToLongBits(this.getBtheta());
            result = result * 59 + (int)($btheta >>> 32 ^ $btheta);
            FastMatrix $td = this.getTd();
            result = result * 59 + ($td == null ? 43 : $td.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "MovingRegression.Airline(td=" + String.valueOf(this.getTd()) + ", regVariance=" + this.getRegVariance() + ", theta=" + this.getTheta() + ", btheta=" + this.getBtheta() + ")";
        }
    }
}

